/*
 * example_plot_compare.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example example_plot_compare.c
 *  \author Fernando Pujaico Rivera
 *  \date 2-09-2016
 *  \brief Programa para el testeo de las funciones de plot en 2D.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsoctplot.h>

int main(int argc, char* argv[])
{

	int i,N;

	PdsVector *X=NULL;
	PdsVector *U=NULL;
	PdsVector *V=NULL;

    N=128;
	X=pds_vector_new(N);
	U=pds_vector_new(N);
	V=pds_vector_new(N);
	
    /* Cargando datos en los vectores X y Y. */
	for(i=0;i<N;i++)	
	{
		X->V[i]=i;
		U->V[i]=sin(2*M_PI*i/N)+0.5*sin(2*2*M_PI*i/N);
		V->V[i]=cos(2*M_PI*i/N)+0.5*cos(2*2*M_PI*i/N);
	}

    /* Creando un archivo PNG con una grafica X vs U,V. */
    pds_octave_plot_compare_vectors(X,U,V,"Eje X","Eje Y","U","V",NULL,"pds_octave_plot_compare_vectors.png");

	return EXIT_SUCCESS;
}

