/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsoctplot.h>

int main(int argc, char* argv[])
{

	int i=0,N,a;
	FILE *fd=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;

	N=16;
	a=4;
	X=pds_vector_new(a*N);
	Y=pds_vector_new(a*N);
	
	fd=fopen("datos.dat","w");
	for(i=0;i<a*N;i++)	
	{
		X->V[i]=0.123*i;
		Y->V[i]=sin(2*M_PI*i/N)+0.5*sin(2*2*M_PI*i/N);
		fprintf(fd,"%e\t%e\n",X->V[i],Y->V[i]);
	}
	fclose(fd);

	pds_octplot_vector_in_png(Y,"Eje X","Eje Y",NULL,"vectory.png");
	pds_octplot_vectors_in_png(NULL,Y,"Eje X","Eje Y",NULL,"vectorxy.png");

	pds_octplot_compare_vectors_in_png(NULL,X,Y,"n","f(n)","X","Y",NULL,"vector_xy.png");

	pds_octplot_file_col_in_png("datos.dat",2,"n","Y[n]",NULL,"filecol2.png");
	pds_octplot_file_cols_in_png("datos.dat",1,2,"X[n]","Y[n]",NULL,"filecol12.png");

	pds_vector_free(X);
	pds_vector_free(Y);

	return EXIT_SUCCESS;
}

