/*
 * example_training_save.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example example_training_save.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2012
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */
    
#include <stdlib.h>
#include <math.h>
    
#include <pds/pdsra.h>
#include <pds/pdsnn.h>
    
// ./test/example_training_save ../test/data.mlayer 
int main(int argc, char** argv)
{
    PdsNnNatural i,id,IterN,IterP;
    PdsNnNatural Ntraining=128;
    
    // Creating the neural network
    PdsNnNatural Larray[]={64,128,64,48,14,7};
    PdsNnNatural Nel=6;
    PdsNeuronML *MLayer=pds_neuronml_new_from_array(Larray,Nel);
    if(MLayer==NULL)    return EXIT_FAILURE;
    
    // Configuring the neural network
    PdsNnReal    Alpha=0.6;     pds_neuronml_set_alpha(MLayer,Alpha);
    PdsNnReal    Error=0.1;     pds_neuronml_set_max_error(MLayer,Error);
    PdsNnNatural MaxIter=8192;  pds_neuronml_set_max_iterations(MLayer,MaxIter);
    
    // Creating temporal vectors X and Y.
    PdsVector *X = pds_vector_new(Larray[0]);
    PdsVector *Y = pds_vector_new(Larray[Nel-1]);
    if( (X==NULL)||(Y==NULL) )  return EXIT_FAILURE;
    
    // Training the neural network
    id=0;
    for(i=0;id<Ntraining;i++)
    {
        printf("\nTraining %4d: id=%4d\n",i,id);
        
        // Training with negative data.
        pds_generate_data_input_rand(X,1.0);
        pds_generate_data_output_negative(Y);   // Loading randomly a negative data vectors {X,Y}
        
        pds_neuronml_training(MLayer,X,Y);
        IterN=pds_neuronml_training_results_printf(MLayer,"-1");
        
        // Training with positive data.
        pds_generate_data_input_func2pi(X,sin,6,0.05);
        pds_generate_data_output_positive(Y);   // Loading randomly a positive data vectors {X,Y}
        
        pds_neuronml_training(MLayer,X,Y);
        IterP=pds_neuronml_training_results_printf(MLayer,"+1");
        
        if( (IterP==0)&&(IterN==0) )    id++;
        else                            id=0;
    }
    
    if(argc>1) 
    {
        pds_neuronml_save_data(MLayer,argv[1]);
        printf("\nSaving neural network in %s\n\n",argv[1]);
    }
    else
    {
        pds_neuronml_save_data(MLayer,"data.mlayer");
        printf("\nSaving neural network in data.mlayer\n\n");
    }
    
    pds_neuronml_free(MLayer);
    
    pds_vector_free(X);
    pds_vector_free(Y);
    
    return EXIT_SUCCESS;
}

