/*
 * data_work.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file data_work.h
 *  \author Fernando Pujaico Rivera
 *  \date 4-01-2012
 *  \brief Funciones extras para plotar en octave.
 *  
 */

#ifndef __DATA_WORK_H__
#define __DATA_WORK_H__

#ifdef __cplusplus
extern "C" {
#endif 
#include <time.h> 
#include <pds/pdsrv.h>
int function_data_work_init_data0(PdsVector *X,PdsVector *Y)
{
	if(X==NULL)	return FALSE;

    ////////////////////////////////////////////////////////////////////////////
	if(Y!=NULL) pds_vector_init_value(Y,-1.0);

    ////////////////////////////////////////////////////////////////////////////
    PdsUniform *RV=pds_uniform_new(-128,128);
	if(RV==NULL)	return FALSE;  
    pds_uniform_init(RV,1.0*(clock()%128));
 	
	pds_uniform_get_vector(RV,X);

    pds_uniform_free(RV);

    return TRUE;
}
int function_data_work_init_data1(PdsVector *X,PdsVector *Y)
{
	PdsRaNatural i;
	PdsRvReal m,phase;
	float Ciclos=3;

	if(X==NULL)	return FALSE;

    ////////////////////////////////////////////////////////////////////////////
	if(Y!=NULL) pds_vector_init_value(Y,+1.0);

    ////////////////////////////////////////////////////////////////////////////
    PdsUniform *RV=pds_uniform_new(-128,128);
	if(RV==NULL)	return FALSE;      
  
    pds_uniform_init(RV,1.0*(clock()%128)); 	

	pds_uniform_get_value(RV,&phase);
    phase=M_PI*phase/128.0;

	for(i=0;i<X->Nel;i++)	
	{
		pds_uniform_get_value(RV,&m);
		X->V[i]=128*sin(2*M_PI*Ciclos*i/(1.0*X->Nel)+phase)+0.1*m;
	}

    pds_uniform_free(RV);
	return TRUE;
}


#ifdef __cplusplus
}
#endif 


#endif /* __DATA_WORK_H__ */

