/*
 * extras.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file extras.h
 *  \author Fernando Pujaico Rivera
 *  \date 4-01-2012
 *  \brief Funciones extras para plotar en octave.
 *  
 */

#ifndef __EXTRAS_H__
#define __EXTRAS_H__

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pds/pdsvector.h>

/** \fn int pds_octplot_vector_in_png(const PdsVector *V,const char *labelx,const char *labely,const char *octfile,const char *pngfile)
 *  \brief Imprime un vector V en un archivo png usando como intermedio un 
 *  archivo *.m de octave.
 *  \param[in] V Vector a imprimir.
 *  \param[in] labelx Etiqueta del eje X.
 *  \param[in] labely Etiqueta del eje Y.
 *  \param[in] octfile Nombre del archivo *.m de octave que se usará de intermediario.
 *  \param[in] pngfile Nombre del archivo *.png de salida.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo punteros igual a NULL.
 */
int pds_octplot_vector_in_png(const PdsVector *V,const char *labelx,const char *labely,const char *octfile,const char *pngfile)
{
	int i;
	FILE *fd=NULL;
	char *orden=NULL;

	if(V==NULL)		return FALSE;
	if(labelx==NULL)	return FALSE;
	if(labely==NULL)	return FALSE;
	if(octfile==NULL)	return FALSE;
	if(pngfile==NULL)	return FALSE;

	fd=fopen(octfile,"w");
	if(fd==NULL)		return FALSE;
	fprintf(fd,"V=[");
	for(i=0 ; i<V->Nel ; i++)	fprintf(fd,"%e\t",V->V[i]);
	fprintf(fd,"];\n");
	fprintf(fd,"plot(V,\'o-\');\n");
	fprintf(fd,"grid on;\n");
	fprintf(fd,"xlabel(\'%s\');\n",labelx);
	fprintf(fd,"ylabel(\'%s\');\n",labely);
	fprintf(fd,"print(\'%s\',\'-dpng\',\'-Farial:20\',\'-S800,600\');\n",pngfile);
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	fclose(fd);

	orden=(char *)calloc(1,32+strlen(octfile));
	if(orden==NULL)	return FALSE;
	sprintf(orden,"octave --silent %s",octfile);
	i=system(orden);

	return TRUE;
}

#ifdef __cplusplus
}
#endif 


#endif /* __EXTRAS_H__ */

