/*
 * testprog2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2012
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsrv.h>
#include <pds/pdsnn.h>
#include "extras.h"

int pds_vector_init_func(PdsVector *V,PdsUniform *RV,float (*func)(float));
float funcion(float n);

int main(int argc, char** argv)
{
	PdsNeuronML *MLayer=NULL;
	PdsNeuronML *MLayerTest=NULL;
	PdsVector *L=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;
	PdsUniform *Xrv=NULL;
	PdsUniform *Wrv=NULL;
	PdsUniform *Urv=NULL;
	PdsNnReal m;

	PdsNnNatural i,id,N;
	PdsNnNatural MaxIter,IterN,IterP;
	PdsNnReal Error;
	PdsNnReal Alpha;
	PdsNnReal Sigma;

	FILE *fd=NULL;

	// Creo una Random Variable de entrada
	Xrv=pds_uniform_new(-128,128);

	// Creo una Random Variable para los pesos
	Wrv=pds_uniform_new(-1,1);

	// Creo una Random Variable para los umbrales
	Urv=pds_uniform_new(-1,1);

	// Creo el vector que indicará la cantidad de electrones por capa.
	// 5 Capas.
	L=pds_vector_new(6);
	L->V[0]=32;	L->V[1]=56;	L->V[2]=42;
	L->V[3]=28;	L->V[4]=14;	L->V[5]=7;

	// Creo El vector de entrada X.
	X=pds_vector_new(L->V[0]);
	// Creo El vector de entrada Y.
	Y=pds_vector_new(L->V[5]);

	////////////////////////////////////////////////////////////////////////

	N=100;
	MaxIter=8192;
	Error=sqrt(4.0)/sqrt(7.0);
	Alpha=0.6;
	Sigma=0.05;

	MLayer=pds_neuronml_new(L);
	pds_neuronml_init_uniform_synaptic_weight(MLayer,Wrv);
	pds_neuronml_init_uniform_u(MLayer,Urv);
	pds_neuronml_set_alpha(MLayer,Alpha);
	pds_neuronml_set_sigma(MLayer,Sigma);
	pds_neuronml_set_max_error(MLayer,Error);
	pds_neuronml_set_max_number_iterations(MLayer,MaxIter);
	pds_neuronml_enable_printf(MLayer);

	// Entrenando
	id=0;
	for(i=0;id<N;i++)
	{
		printf("\nEntrenando %d\n",i);

		// Entrenando de forma negativa.
		pds_uniform_get_vector(Xrv,X);
		pds_vector_init_value(Y,-1.0);
		pds_neuronml_training(MLayer,X,Y);
		pds_neuronml_get_number_iterations(MLayer,&IterN);
		printf("%6d<<Negativo>>\t",IterN);
		printf("Y=\t");	pds_vector_printf(Y);

		// Entrenando de forma positiva.
		pds_vector_init_func(X,Xrv,funcion);
		pds_vector_init_value(Y,1.0);
		pds_neuronml_training(MLayer,X,Y);
		pds_neuronml_get_number_iterations(MLayer,&IterP);
		printf("%6d<<Positivo>>\t",IterP);
		printf("Y=\t");	pds_vector_printf(Y);
		
		if((IterN==0)&&(IterP==0))	id++;
		else				id=0;
	}

	fd=fopen("data.txt","w");
	pds_neuronml_fprintf(MLayer,fd);
	fclose(fd);

	MLayerTest=pds_neuronml_new(L);

	fd=fopen("data.txt","r");
	pds_neuronml_fscanf(MLayerTest,fd);
	fclose(fd);



	printf("\n\n");
	// Iterando
	for(i=0;i<N;i++)
	{
		pds_vector_init_func(X,Xrv,funcion);
		pds_neuronml_iterate(MLayerTest,X,Y);
		pds_neuronml_get_soft_vote(MLayerTest,&m);
		printf("H:%5.2f <<Positivo>>\t",m);
		printf("Y=\t");	pds_vector_printf(Y);
		//if(m< 0)	break;
	}
	pds_octplot_vector_in_png(X,"n","X[n]","octfilegood.m","xgood.png");

	printf("\n");
	for(i=0;i<N;i++)
	{
		pds_uniform_get_vector(Xrv,X);
		pds_neuronml_iterate(MLayerTest,X,Y);
		pds_neuronml_get_soft_vote(MLayerTest,&m);
		printf("H:%5.2f <<Negativo>>\t",m);
		printf("Y=\t");	pds_vector_printf(Y);
		//if(m>=0)	break;
	}
	pds_octplot_vector_in_png(X,"n","X[n]","octfilebad.m","xbad.png");


	pds_neuronml_free(MLayer);
	pds_neuronml_free(MLayerTest);

	printf("\n");

	pds_vector_free(X);
	pds_vector_free(Y);
	pds_vector_free(L);
	pds_uniform_free(Xrv);
	pds_uniform_free(Wrv);
	pds_uniform_free(Urv);

	return EXIT_SUCCESS;
}

int pds_vector_init_func(PdsVector *V,PdsUniform *RV,float (*func)(float))
{
	PdsRaNatural i;
	PdsRvReal m,phase;

	if(V==NULL)	return FALSE;

	pds_uniform_get_value(RV,&phase);
	for(i=0;i<V->Nel;i++)	
	{
		pds_uniform_get_value(RV,&m);
		V->V[i]=func(i+phase*M_PI/128.0)+0.25*m;
	}

	return TRUE;
}

float funcion(float n)
{
	float F0=50;
	float Fs=512;
	float e,y;

	y=128*sin(2*M_PI*F0*n/Fs);

	return y+e;
}
