#!/bin/bash


FILENAME=( "mbscpack" "msbscpack")

for i in ${FILENAME[*]}; 
do i=$[i-1]; 

    dia ${FILENAME[$i]}.dia -t mp --export=${FILENAME[$i]}.mp

    echo "\documentclass{article}
    \pagestyle{empty}
    \usepackage{graphicx}
    \begin{document}
    \includegraphics[width=\textwidth]{"${FILENAME[$i]}.1"}
    \end{document}" > temporallatex-${FILENAME[$i]}.tex

    mpost  -tex=latex -interaction=nonstopmode ${FILENAME[$i]}.mp
    latex temporallatex-${FILENAME[$i]}.tex
    dvips -E -o temporallatex-${FILENAME[$i]}.eps temporallatex-${FILENAME[$i]}

    rm -f ${FILENAME[$i]}.log
    rm -f ${FILENAME[$i]}.mpx
    rm -f ${FILENAME[$i]}.mp
    rm -f ${FILENAME[$i]}.1

    rm -f temporallatex-${FILENAME[$i]}.tex
    rm -f temporallatex-${FILENAME[$i]}.aux  
    rm -f temporallatex-${FILENAME[$i]}.log  
    rm -f temporallatex-${FILENAME[$i]}.dvi

    convert -density 100 temporallatex-${FILENAME[$i]}.eps -flatten ${FILENAME[$i]}.png

    rm -f temporallatex-${FILENAME[$i]}.eps

done




