/*
 * testprog3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog3.c
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Test de un generador de ondas. 
 *
 *  <br>
 *  <br>
 *  \image html test3grafico1.png "Generador de ondas"
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsds.h>
#include <pds/pdsvector.h>
#include "extras.h"
#include <math.h>

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsWave *WAVE=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;
	PdsDsNatural N,n,i;

	FILE *fd=NULL;
	char DATAFILE[]="datos.txt";
	char OCTAVEFILE[]="plotinoctave.m";

	N=64;
	Y=pds_vector_new(8*N);
	if(Y==NULL)	return EXIT_FAILURE;

	///////////////////////////////////////////////////////////////
	X=pds_vector_new(N);
	if(X==NULL)	return EXIT_FAILURE;
	for(i=0;i<N;i++)	X->V[i]=i;
	///////////////////////////////////////////////////////////////

	
	///////////////////////////////////////////////////////////////
	WAVE=pds_wave_new_vector(X);
	if(WAVE==NULL)	return EXIT_FAILURE;	
	n=pds_wave_get_vector(WAVE,Y);
	pds_wave_free(WAVE);
	///////////////////////////////////////////////////////////////

	fd=fopen(DATAFILE,"w");
	if(fd==NULL)	return EXIT_FAILURE;
	pds_vector_fprintf(Y,fd);
	fclose(fd);	

	pds_octave_plot_lin(OCTAVEFILE,DATAFILE);


	pds_vector_free(X);	
	pds_vector_free(Y);	

	return EXIT_SUCCESS;
}
