/*
 * testprog2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Test de un generador IQ para una frecuencia de pi/32. 
 *
 *  <br>
 *  La frecuencia de muestro es 2*pi.
 *  <br>
 *  Test de un generador IQ.
 *  \f[ yc[n]=A~cos[(n+1)\frac{\pi}{32}] \f]
 *  \f[ ys[n]=A~sin[(n+1)\frac{\pi}{32}] \f]
 *  \f[ yc[n]=A~cos[\frac{\pi}{32}]~~~yc[-1]=A~~~\f]
 *  \f[ ys[n]=A~sin[\frac{\pi}{32}]~~~ys[-1]=0~~~\f]
 *  <br>
 *  \image html pdsiqwave.png "Generador IQ sinusoidal digital"
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsds.h>
#include <pds/pdsvector.h>
#include "extras.h"
#include <math.h>

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsIQWave *WAVE=NULL;
	PdsVector *Yc=NULL;
	PdsVector *Ys=NULL;
	PdsDsReal A,Teta;
	PdsDsNatural N,n;

	FILE *fd=NULL;
	char DATAFILE[]="datos.txt";
	char OCTAVEFILE[]="plotinoctave.m";


	A=1.0;
	Teta=M_PI/32.0;
	N=256;
	Yc=pds_vector_new(N);
	if(Yc==NULL)	return EXIT_FAILURE;
	Ys=pds_vector_new(N);
	if(Ys==NULL)	return EXIT_FAILURE;

	WAVE=pds_iqwave_new(A,Teta);
	if(WAVE==NULL)	return EXIT_FAILURE;
	
	n=pds_iqwave_get_vector(WAVE,Yc,Ys);

	fd=fopen(DATAFILE,"w");
	if(fd==NULL)	return EXIT_FAILURE;
	pds_vector_fprintf(Yc,fd);
	pds_vector_fprintf(Ys,fd);
	fclose(fd);

	pds_octave_plot_2lin(OCTAVEFILE,DATAFILE);

	pds_iqwave_free(WAVE);
	pds_vector_free(Yc);	
	pds_vector_free(Ys);	


	return EXIT_SUCCESS;
}
