/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file testprog1.c
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Test de un generador sinusoidal para una frecuencia de pi/32. 
 *
 *  <br>
 *  La frecuencia de muestro es 2*pi.
 *  <br>
 *  Test de un generador sinusoidal.
 *  \f[ y[n]=A~sin[(n+1)\frac{\pi}{32}]u[n] \f]
 *  \f[ y[0]=A~sin[\frac{\pi}{32}]~~~y[-1]=0~~~y[-2]=0~~~... \f]
 *  <br>
 *  \image html test1grafico1.png "Señal de salida y[n]."
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsds.h>
#include <pds/pdsvector.h>
#include "extras.h"
#include <math.h>

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsSWave *WAVE=NULL;
	PdsVector *Y=NULL;
	PdsDsReal A,Teta;
	PdsDsNatural N;

	FILE *fd=NULL;
	char DATAFILE[]="datos.txt";
	char OCTAVEFILE[]="plotinoctave.m";


	A=1.0;
	Teta=M_PI/32.0;
	N=256;
	Y=pds_vector_new(N);
	if(Y==NULL)	return EXIT_FAILURE;

	WAVE=pds_swave_new(A,Teta);
	if(WAVE==NULL)	return EXIT_FAILURE;
	
	pds_swave_get_vector(WAVE,Y);

	fd=fopen(DATAFILE,"w");
	if(fd==NULL)	return EXIT_FAILURE;
	pds_vector_fprintf(Y,fd);
	fclose(fd);

	pds_octave_plot_lin(OCTAVEFILE,DATAFILE);

	pds_swave_free(WAVE);
	pds_vector_free(Y);	


	return EXIT_SUCCESS;
}
