/*
 * extras.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file extras.h
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Funciones extras para plotar en octave.
 *  
 */

#ifndef __EXTRAS_H__
#define __EXTRAS_H__

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <pds/pdsvector.h>

// Grafica las columnas del archivo datacolfile.
int pds_octave_plot_col(char nombre[],char datacolfile[])
{
	FILE *fd=NULL;
	char *orden=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\');\n",datacolfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"for II=1:Ny\n");
	fprintf(fd,"\tfigure(II);\n");
	fprintf(fd,"\tplot(Y(:,II),\'o-\');\n");
	fprintf(fd,"\tgrid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"\txlabel('n');\n");
	fprintf(fd,"\tylabel('f(n)');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\tnombre=sprintf('grafico%cd.png',II);\n",'%');
	fprintf(fd,"\tprint(nombre,'-dpng','-Farial:20','-S400,300');\n");
	fprintf(fd,"\n");
	fprintf(fd,"end\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	orden=(char *)calloc(1,16+strlen(nombre));
	sprintf(orden,"octave %s",nombre);
	n=system(orden);

	return 1;
}

// Grafica las lineas del archivo datacolfile.
int pds_octave_plot_lin(char nombre[],char datacolfile[])
{
	FILE *fd=NULL;
	char *orden=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\')';\n",datacolfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"for II=1:Ny\n");
	fprintf(fd,"\tfigure(II);\n");
	fprintf(fd,"\tplot(Y(:,II),\'o-\');\n");
	fprintf(fd,"\tgrid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"\txlabel('n');\n");
	fprintf(fd,"\tylabel('f(n)');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\tnombre=sprintf('grafico%cd.png',II);\n",'%');
	fprintf(fd,"\tprint(nombre,'-dpng','-Farial:20','-S400,300');\n");
	fprintf(fd,"\n");
	fprintf(fd,"end\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	orden=(char *)calloc(1,16+strlen(nombre));
	sprintf(orden,"octave %s",nombre);
	n=system(orden);

	return 1;
}

// Grafica las 2lineas del archivo datacolfile.
int pds_octave_plot_2lin(char nombre[],char datacolfile[])
{
	FILE *fd=NULL;
	char *orden=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\')';\n",datacolfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"plot([0:Nx-1],Y(:,1),\'o-\',[0:Nx-1],Y(:,2),\'o-\');\n");
	fprintf(fd,"grid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"xlabel('n');\n");
	fprintf(fd,"ylabel('Y(n)');\n");
	fprintf(fd,"\n");
	fprintf(fd,"print('grafico.png','-dpng','-Farial:20','-S400,300');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	orden=(char *)calloc(1,16+strlen(nombre));
	sprintf(orden,"octave %s",nombre);
	n=system(orden);

	return 1;
}


#ifdef __cplusplus
}
#endif 


#endif /* __EXTRAS_H__ */

