/*
 * testprog8.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog8.c
 *  \author Fernando Pujaico Rivera
 *  \date 28-01-2012
 *  \brief Prueba de los utilitarios de la biblioteca.
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsdf.h>
#include <pds/pdsvector.h>
#include "extras.h"


int main(int argc, char** argv)
{
	PdsVector *Hnum=NULL;
	PdsVector *Hden=NULL;
	PdsVector *H=NULL;
	PdsVector *Hband=NULL;
	PdsVector *Hreject=NULL;
	PdsVector *H2=NULL;

	H2=pds_vector_new(200);

	//Hnum=pds_df_butterworth_hnum_new(7,0.25);
	//Hden=pds_df_butterworth_hden_new(7,0.25);
    Hden=pds_vector_new(7);
    Hnum=pds_vector_new(7);
    pds_vector_lowpass_butterworth(Hnum,Hden,0.25);
	pds_vector_iir_frequency_response(Hnum,Hden,H2);
	pds_octplot_vector_in_png(H2,"k","Butterworth:|H(k)|^2","modulohiir.m","modulohiir.png");
	pds_vector_free(Hnum);
	pds_vector_free(Hden);

	H=pds_vector_new_lowpass_rectangular(14,0.25);
	pds_vector_fir_frequency_response(H,H2);
	pds_octplot_vector_in_png(H2,"k","Rectangular:|H(k)|^2","modulohfir1.m","modulohfir1.png");
	pds_vector_free(H);

	H=pds_vector_new_lowpass_hanning(14,0.25);
	pds_vector_fir_frequency_response(H,H2);
	pds_octplot_vector_in_png(H2,"k","Hanning:|H(k)|^2","modulohfir2.m","modulohfir2.png");
	pds_vector_free(H);

	H=pds_vector_new_lowpass_hamming(14,0.25);
	pds_vector_fir_frequency_response(H,H2);
	pds_octplot_vector_in_png(H2,"k","Hamming:|H(k)|^2","modulohfir3.m","modulohfir3.png");
	pds_vector_free(H);

	H=pds_vector_new_lowpass_hamming(14,0.25);
	pds_vector_lowpass_to_highpass(H);
	pds_vector_fir_frequency_response(H,H2);
	pds_octplot_vector_in_png(H2,"k","Hamming|H(k)|^2","modulohfir4.m","modulohfir4.png");
	pds_vector_free(H);

	H=pds_vector_new_lowpass_rectangular(14,0.25);
	Hband=pds_vector_new_lowpass_to_bandpass(H);
	pds_vector_fir_frequency_response(Hband,H2);
	pds_octplot_vector_in_png(H2,"k","Rectangular:|H(k)|^2","modulohfir5.m","modulohfir5.png");
	pds_vector_free(Hband);
	pds_vector_free(H);

	H=pds_vector_new_lowpass_rectangular(14,0.25);
	Hreject=pds_vector_new_lowpass_to_bandreject(H);
	pds_vector_fir_frequency_response(Hreject,H2);
	pds_octplot_vector_in_png(H2,"k","Rectangular:|H(k)|^2","modulohfir6.m","modulohfir6.png");
	pds_vector_free(Hreject);
	pds_vector_free(H);


	pds_vector_free(H2);

	return EXIT_SUCCESS;
}
