/*
 * extras.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file extras.h
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Funciones extras para plotar en octave.
 *  
 */

#ifndef __EXTRAS_H__
#define __EXTRAS_H__

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <pds/pdsvector.h>

// Grafica las columnas del archivo datacolfile y crea un archivo de matlab con el 'nombre'.
int pds_octave_plot_col(char nombre[],char datacolfile[])
{
	FILE *fd=NULL;
	char *ORDEN=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\');\n",datacolfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"for II=1:Ny\n");
	fprintf(fd,"\tfigure(II);\n");
	fprintf(fd,"\tplot(Y(:,II),\'o-\');\n");
	fprintf(fd,"\tgrid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"\txlabel('n');\n");
	fprintf(fd,"\tylabel('f(n)');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\tnombre=sprintf('grafico%cd.png',II);\n",'%');
	fprintf(fd,"\tprint(nombre,'-dpng','-Farial:20','-S800,600');\n");
	fprintf(fd,"\n");
	fprintf(fd,"end\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	ORDEN=(char*)calloc(1,strlen(nombre)+16);
	sprintf(ORDEN,"octave -q %s\n",nombre);
	n=system(ORDEN);
	free(ORDEN);
	return 1;
}

// Grafica las lineas del archivo datalinfile y crea un archivo de matlab con el 'nombre'.
int pds_octave_plot_lin(char nombre[],char datalinfile[])
{
	FILE *fd=NULL;
	char *ORDEN=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\')';\n",datalinfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"for II=1:Ny\n");
	fprintf(fd,"\tfigure(II);\n");
	fprintf(fd,"\tplot(Y(:,II),\'-o\');\n");
	fprintf(fd,"\tgrid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"\txlabel('n');\n");
	fprintf(fd,"\tylabel('f(n)');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\tnombre=sprintf('grafico%cd.png',II);\n",'%');
	fprintf(fd,"\tprint(nombre,'-dpng','-Farial:20','-S800,600');\n");
	fprintf(fd,"\n");
	fprintf(fd,"end\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	ORDEN=(char*)calloc(1,strlen(nombre)+16);
	sprintf(ORDEN,"octave -q %s\n",nombre);
	n=system(ORDEN);
	free(ORDEN);

	return 1;
}

// Grafica las lineas del archivo datalinfile y crea un archivo de matlab con el 'nombre'.
int pds_octave_plot_lin_fft(char nombre[],char datalinfile[])
{
	FILE *fd=NULL;
	char *ORDEN=NULL;
	int n;
	
	fd=fopen(nombre,"w");
	if(fd==NULL)	return 0;

	fprintf(fd,"Y=load(\'%s\')';\n",datalinfile);
	fprintf(fd,"\n");
	fprintf(fd,"t=size(Y);\n");
	fprintf(fd,"Nx=t(1);\n");
	fprintf(fd,"Ny=t(2);\n");
	fprintf(fd,"\n");
	fprintf(fd,"x1=[0:(Nx-1)]'*2.0*pi/Nx;\n");
	fprintf(fd,"x6=[0:6*Nx-1]'*2.0*pi/(6*Nx);\n");
	fprintf(fd,"ceros=0*x1;\n");
	fprintf(fd,"\n");
	fprintf(fd,"for II=1:Ny\n");
	fprintf(fd,"\tfigure(II);\n");
	fprintf(fd,"\tY1=abs(fft(Y(:,II)));\n");
	fprintf(fd,"\ty6=[Y(:,II);ceros;ceros;ceros;ceros;ceros];\n");
	fprintf(fd,"\tY6=abs(fft(y6));\n");
	fprintf(fd,"\tplot(x1,Y1,'*',x6,Y6,'--');\n");
	fprintf(fd,"\tgrid on;\n");
	fprintf(fd,"\n");
	fprintf(fd,"\txlabel('angle');\n");
	fprintf(fd,"\tylabel('FFT');\n");
	fprintf(fd,"\n");
	fprintf(fd,"\tnombre=sprintf('graficofft%cd.png',II);\n",'%');
	fprintf(fd,"\tprint(nombre,'-dpng','-Farial:20','-S800,600');\n");
	fprintf(fd,"\n");
	fprintf(fd,"end\n");
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	
	fclose(fd);

	ORDEN=(char*)calloc(1,strlen(nombre)+16);
	sprintf(ORDEN,"octave -q %s\n",nombre);
	n=system(ORDEN);
	free(ORDEN);

	return 1;
}


/** \fn int pds_octplot_vector_in_png(const PdsVector *V,const char *labelx,const char *labely,const char *octfile,const char *pngfile)
 *  \brief Imprime un vector V en un archivo png usando como intermedio un 
 *  archivo *.m de octave.
 *  \param[in] V Vector a imprimir.
 *  \param[in] labelx Etiqueta del eje X.
 *  \param[in] labely Etiqueta del eje Y.
 *  \param[in] octfile Nombre del archivo *.m de octave que se usará de intermediario.
 *  \param[in] pngfile Nombre del archivo *.png de salida.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo punteros igual a NULL.
 */
int pds_octplot_vector_in_png(const PdsVector *V,const char *labelx,const char *labely,const char *octfile,const char *pngfile)
{
	int i;
	FILE *fd=NULL;
	char *orden=NULL;

	if(V==NULL)		return FALSE;
	if(labelx==NULL)	return FALSE;
	if(labely==NULL)	return FALSE;
	if(octfile==NULL)	return FALSE;
	if(pngfile==NULL)	return FALSE;

	fd=fopen(octfile,"w");
	if(fd==NULL)		return FALSE;
	fprintf(fd,"V=[");
	for(i=0 ; i<V->Nel ; i++)	fprintf(fd,"%e\t",V->V[i]);
	fprintf(fd,"];\n");
	fprintf(fd,"plot(V,\'o-\');\n");
	fprintf(fd,"grid on;\n");
	fprintf(fd,"xlabel(\'%s\');\n",labelx);
	fprintf(fd,"ylabel(\'%s\');\n",labely);
	fprintf(fd,"print(\'%s\',\'-dpng\',\'-Farial:20\',\'-S800,600\');\n",pngfile);
	fprintf(fd,"\n");
	fprintf(fd,"\n");
	fclose(fd);

	orden=(char *)calloc(1,32+strlen(octfile));
	if(orden==NULL)	return FALSE;
	sprintf(orden,"octave --silent %s",octfile);
	i=system(orden);

	return TRUE;
}

#ifdef __cplusplus
}
#endif 


#endif /* __EXTRAS_H__ */

