/*
 * testpdsstring3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testpdsstring3.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsstring3 testpdsstring3.c -lpdsdatafunc

# Test command
./testpdsstring3
\endverbatim
O resultado seria:
\verbatim
str_in :[Hola <b>Fernando</b> como está <b>TrucomanX</b> y <b></b>fff]
str_out:[Hola <b>FERNANDO</b> como está <b>TRUCOMANX</b> y <b></b>fff]
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <string.h> //strlen
#include <ctype.h>  //toupper
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    

int main(int argc, char* argv[])
{
    char str_in[]="Hola <b>Fernando</b> como está <b>TrucomanX</b> y <b></b>fff";
    char *str_out;
    
    printf("str_in :[%s]\n",str_in);
    
    str_out=pds_string_content_replacement (str_in, "<b>", "</b>", pds_toupper);
    
    printf("str_out:[%s]\n",str_out);
    
    return EXIT_SUCCESS;
}

