/*
 * testpdsstring.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testpdsstring.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsstring testpdsstring.c -lpdsdatafunc

# Test command
./testpdsstring 
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
    
int main(int argc, char* argv[])
{
    char string[] = " & * Samba, Gafieira ; Puladinho,Gafieira  **  ";
    const char delimiters[] = ",;:";
    const char cleanchars[] = " &*";
    
    PdsCellString *token=NULL;
    char *DATA=NULL; 
    
    
    // Input data.
    printf("\n");
    printf("          string[%s]\n",string);
    printf("      cleanchars[%s]\n",cleanchars);
    pds_string_multi_clean_beginning(string,cleanchars);
    pds_string_multi_clean_ending(string,cleanchars);
    printf(" string(cleaned)[%s]\n",string);
    printf("      delimiters[%s]\n",delimiters);
    printf("\n\n");
    
    
    // Creating a cell tring using delimiters.
    printf("<<<< data in string(cleaned) >>>>\n");
    token=pds_strsep_cell_string(string,delimiters);    
    if(token!=NULL)
    pds_cell_string_all_printf(token);
    printf("\n\n");
    
    
    // Joint the cell strings with separators.
    DATA=pds_strcat_cell_string(token,"<sep>");
    if(DATA!=NULL)  printf("%s\n\n",DATA);
    free(DATA);
        
    
    // Creating a string with sprintf.
    printf("<<<< pds_sprintf(\"%%d - %%s - %%f - %%p\", 33,\"text\",1.68,&string) >>>>\n");
    DATA=pds_sprintf("%d - %s - %f - %p", 33,"text",1.68,&string);
    if(DATA!=NULL)  printf("%s\n\n",DATA);
    free(DATA);
    
    
    // Loading a string from a file
    printf("<<<< pds_string_new_from_file(\"filedata.metadata\") >>>>\n");
    DATA=pds_string_new_from_file("filedata.metadata");
    if(DATA!=NULL)  printf("%s\n\n",DATA);
    free(DATA);
    
    
    // Comparing two strings of a no case sensitive way.
    printf("<<<< pds_strcicmp(\"Hola\",\"HOLA\") >>>>\n");
    if(pds_strcicmp("Hola","HOLA")==0)  printf("They are equals.\n\n");
    else                                printf("They are differents.\n\n");
        
    // Comparing two strings lexicograficamente.
    char str1[]="ab10a";
    char str2[]="ab1b";
    printf("<<<< pds_strlexcmp(\"%s\",\"%s\") >>>>\n",str1,str2);
    if(pds_strlexcmp(str1,str2)==0)  printf("%s == %s\n\n",str1,str2);
    if(pds_strlexcmp(str1,str2) <0)  printf("%s  < %s\n\n",str1,str2);
    if(pds_strlexcmp(str1,str2) >0)  printf("%s  < %s\n\n",str2,str1);

    char str[]="-37 i";
    printf("<<<< isintnumber(\"%s\") = %d>>>>\n\n",str,isintnumber(str));
    
    return EXIT_SUCCESS;
}

