/*
 * testpdsfilesfunc6.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc6.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsfilesfunc.h&gt; .
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsfilesfunc6 testpdsfilesfunc6.c -lpdsdatafunc

# Test command
./testpdsfilesfunc6
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
char *func(const char *data)
{
    char *rep=NULL;
    
    rep=(char*)calloc(32,1);
    sprintf(rep,"tango");
    return rep;
}
    
int main(int argc, char* argv[])
{
    char FILE_INPUT[]  ="filedata.metadata";
    char FILE_OUTPUT1[]="filedata.out1.metadata";
    char FILE_OUTPUT2[]="filedata.out2.metadata";
        
    printf("\n");
    
    
/** Hacer esta funcion  para strings dica: Usa PdsCellString o PdsListString */
    // Replace all occurrences of the text between "=" and "," with the result 
    // of proccess the text with the function "func".
    pds_file_content_replacement(FILE_OUTPUT1,FILE_INPUT,"<b>","</b>",func);
    // Print the content of a file.
    pds_cat(FILE_OUTPUT1);
    
    printf("\n\n");
    
    
    // Replace all occurrences of the text "sertanejo" with the "salsa em linha" text.
    pds_file_pattern_replacement(FILE_OUTPUT2,FILE_INPUT,"dat1","dat4");
    // Print the content of a file.
    pds_cat(FILE_OUTPUT2);
    
    printf("\n");  
    
    // Optional 
    remove(FILE_OUTPUT1);
    remove(FILE_OUTPUT2);
    
    return EXIT_SUCCESS;
}

