/*
 * testpdsfilesfunc.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsfilesfunc.h&gt; .
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsfilesfunc testpdsfilesfunc.c -lpdsdatafunc

# Test command
./testpdsfilesfunc /text/file.c
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
#if defined(_WINDOWS_) || defined(_WIN32) || defined(WIN32)
    #define DEFAULT_NOEXISTENT_FILEPATH "C:\\path\\to\\file\\filename.h"
#elif defined(__linux__)
    #define DEFAULT_NOEXISTENT_FILEPATH "/path/to/file/filename.h"
#else
    #define DEFAULT_NOEXISTENT_FILEPATH "/path/to/file/filename.h"
#endif
    
int main(int argc, char* argv[])
{
    const char *filepath1=NULL;
    char *DATA=NULL;
    
    if(argc==1)
        filepath1=DEFAULT_NOEXISTENT_FILEPATH;
    else
        filepath1=argv[1];
    
    // Getting data from  a filepath
    printf("\n<<<< Data from %s >>>>\n",filepath1);
    
    DATA=pds_get_basename(filepath1);
    printf("basename :\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_filename_extension(filepath1);
    printf("extension:\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_filename(filepath1);
    printf("filename :\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_dirname(filepath1);
    printf("dirname  :\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_filepath_with_extension(filepath1,"mp4");
    printf("other_ext:\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_temporal_filepath(filepath1,NULL);
    printf("temporal :\t%s\n",DATA);
    free(DATA);
    
    DATA=pds_get_temporal_filepath(filepath1,NULL);
    printf("temporal :\t%s\n",DATA);
    free(DATA);
    

    
    return EXIT_SUCCESS;
}

