/*
 * testpdsfnmatch.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testpdsfnmatch.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>


int main(int argc, char* argv[])
{
    int id;
    
    ////////////////////////////////////////////////////////////////////////////
    const char str0[]= "abcdef";
    const char pat0[]="a*f";
    printf("\n");
    id=pds_fnmatch(pat0, str0,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat0,str0);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat0,str0);
    
    ////////////////////////////////////////////////////////////////////////////
    const char str1[]= "abcdee";
    const char pat1[]="a*f";
    //printf("\n");
    id=pds_fnmatch(pat1, str1,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat1,str1);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat1,str1);
    
    ////////////////////////////////////////////////////////////////////////////
    const char str2[]= "qxx";
    const char pat2[]="[a-z]xx";
    printf("\n");
    id=pds_fnmatch(pat2, str2,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat2,str2);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat2,str2);
    
    ////////////////////////////////////////////////////////////////////////////
    const char str3[]= "dqxx";
    const char pat3[]="[a-z]xx";
    //printf("\n");
    id=pds_fnmatch(pat3, str3,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat3,str3);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat3,str3);
    
    ////////////////////////////////////////////////////////////////////////////
    const char str4[]= "abc";
    const char pat4[]="a??";
    printf("\n");
    id=pds_fnmatch(pat4, str4,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat4,str4);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat4,str4);
    
    ////////////////////////////////////////////////////////////////////////////
    const char str5[]= "abcd";
    const char pat5[]="a??";
    //printf("\n");
    id=pds_fnmatch(pat5, str5,FNM_CASEFOLD);
    if(id==0)   printf("Found \"%s\" in : \"%s\"\n",pat5,str5);
    else        printf("Not found \"%s\" in : \"%s\"\n",pat5,str5);
    
    
    printf("\n");
    
    return EXIT_SUCCESS;
}

