/*
 * testpdsfilesfunc5.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc5.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsfilesfunc.h&gt; .
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsfilesfunc5 testpdsfilesfunc5.c -lpdsdatafunc

# Test command
./testpdsfilesfunc5
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
     
int main(int argc, char* argv[])
{

    char *DATA=NULL;
    char d;
    long int size;
    
    printf("\n");    
    
    printf("argv[0] :: %s\n\n",argv[0]);

    DATA=pds_get_realpath(".");
    printf("pds_get_realpath(\".\")          :: %s\n\n",DATA);
    free(DATA);
    
    DATA=pds_get_homedir();
    printf("pds_get_homedir()              :: %s\n\n",DATA);
    free(DATA);
    
    DATA=pds_get_absolute_dirname();
    printf("pds_get_absolute_dirname()     :: %s\n\n",DATA);
    free(DATA);
    
    DATA=pds_get_absolute_programpath();
    printf("pds_get_absolute_programpath() :: %s\n\n",DATA);
    free(DATA);

    d=pds_filesep();
    printf("pds_filesep()                  :: %c\n\n",d);
    
    size=pds_get_file_size(argv[0]);
    printf("pds_get_file_size(argv[0])     :: %ld\n\n",size);	
    
    printf("\n");    
    
    return EXIT_SUCCESS;
}

