/*
 * testpdsargsfunc.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsargsfunc.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsargsfunc.h&gt; .
 *
 *  <br>
 *
\verbatim
# Compilation command
gcc -o testpdsargsfunc testpdsargsfunc.c -lpdsdatafunc

# Test command
./testpdsargsfunc --int 1 --long 8589934592 --float 3.7 --double 3.7 --chars Hola
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>

int main(int argc, char* argv[])
{
    int       i=0;
    long long l=0;
    float     f=0;
    double    d=0;
    char *    s=NULL; 
    
    if(pds_exist_param(argc,argv,"--int"))    printf("Existe --int\n");
    
    pds_get_int_param   (argc,argv,"--int"   ,&i);
    pds_get_llint_param (argc,argv,"--long"  ,&l);
    pds_get_float_param (argc,argv,"--float" ,&f);
    pds_get_double_param(argc,argv,"--double",&d);
    pds_get_chars_param (argc,argv,"--chars" ,&s);
    
    printf("   --int:\t%d  \n",i);
    printf("  --long:\t%lld\n",l);
    printf(" --float:\t%e  \n",f);
    printf("--double:\t%e  \n",d);
    printf(" --chars:\t%s  \n",s);
    
    return EXIT_SUCCESS;
}

