/*
 * pdsdautils.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

#include <pds/pdsdautils.h>



/** \fn int if_little_endian(void)
 *  \brief Averigua si es Little Endian.
 *  \return TRUE si es Little Endian o FALSE si no.
 *  \ingroup PdsDaUtilsGroup
 */
int if_little_endian(void)
{
	int i = 1;
	char *p = (char *) &i;

	if ( p[0] == 1 )	return TRUE;
	else			return FALSE;
}


