/*
 * pdscm.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdscm.h
 *  \brief Archivo en donde se agrupan todos los módulos de las bibliotecas.
 *
 *  Puedes usar la biblioteca usando el siguiente código.
    @verbatim
	#include <pds/pdscm.h>
    @endverbatim
 *  O tambien puedes habilitar todos los módulos uno por uno.
    @verbatim
	#include <pds/pdscmfunctions.h>
	#include <pds/pdsawgn.h>
	#include <pds/pdsbiawgn.h>
	#include <pds/pdsbsc.h>
    @endverbatim
 *
 */
#ifndef __PDSCM_H__
#define __PDSCM_H__

#include <pds/pdscmfunctions.h>
#include <pds/pdsawgn.h>
#include <pds/pdsbiawgn.h>
#include <pds/pdsbsc.h>
#include <pds/pdsbscblock.h>

#endif /* __PDSCM_H__ */
