/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog1.c
 *  \author Fernando Pujaico Rivera
 *  \date 07-05-2011
 *  \brief Programa para el testeo de la biblioteca PDSBA.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsba.h>

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsBVector *V1=NULL;
	PdsBVector *V2=NULL;
	PdsBaNatural n;
	PdsBaByte B;
	PdsBaBit b;

	V1=pds_bvector_new(100);
	V2=pds_bvector_new(100);

	pds_bvector_init(V1,1);
	pds_bvector_printf(V1);

	pds_bvector_init_rand(V2,0.5);
	pds_bvector_printf(V2);

	pds_bvector_cmp(V1,V2,&n);

	printf("Diferencias:%d\n",n);

	pds_bvector_get_byte(V2,12,&B);
	printf("V2[BYTE{12}]=%X\n",B);

	pds_bvector_set_byte(V2,12,250);
	printf("V2[BYTE{12}] <-- %X\n",250);
	pds_bvector_printf(V2);

	pds_bvector_get_byte(V2,12,&B);
	printf("V2[BYTE{12}]=%X\n",B);

	pds_bvector_get_bit(V2,10,&b);
	printf("V2[BIT{10}]=%X\n",b);

	pds_bvector_set_bit(V2,13,1);
	printf("V2[BIT{13}] <-- %X\n",1);
	pds_bvector_printf(V2);

	pds_bvector_free(V1);
	pds_bvector_free(V2);

	return EXIT_SUCCESS;
}
