// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifdef USE_SQLITE

#include "../libpdrx/common.h"

#include <Poco/Data/Common.h>
#include <Poco/Data/SQLite/Connector.h>
#include <Poco/Data/SQLite/SQLiteException.h>

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;
using namespace Poco::Data;

#include "../libpdrx/datatypes.h"
#include "../libpdrx/config.h"
#include "db_impl.h"

//=== SQLiteDatabase =======================================================
SQLiteDatabase::SQLiteDatabase (const string& connect, bool verbose, bool fast)
	: PocoDatabaseImpl(connect, verbose, fast, SQLite::Connector::KEY, new SQLite::Connector())
{
}

string SQLiteDatabase::GetVersion () const throw (Xception)
{
	try
	{
		string version;
		(*m_pSession) << "select sqlite_version();", into(version), now;
		return string("SQLite ") + version;
	}
	catch (...)
	{
		throw Xception("error determining database version");
	}
}

#endif // USE_SQLITE
