// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DB_IMPL_H
#define __DB_IMPL_H

#include "db.h"
#include "../libpdrx/poco_db.h"

//=== PocoDatabaseImpl (abstract base class) ===============================
class PocoDatabaseImpl: public Database, public PocoDatabase {

	protected:

	typedef map<string, shared_ptr<Selection> > Selections;

	bool m_fast;
	mutable Selections m_selections;

		PocoDatabaseImpl (const string& connect, bool verbose, bool fast, const string& KEY, Poco::Data::Connector* pConnector);

	public:

	virtual	~PocoDatabaseImpl ();

	virtual void Connect () throw (Xception);
	virtual void Select (shared_ptr<Selection>& selection, const string& collection, const ptime& begin, const ptime& end) const throw (Xception);

	protected:

	virtual void NoSchemaCallback () throw (Xception);
};

#ifdef USE_SQLITE
//=== SQLiteDatabase =======================================================
class SQLiteDatabase: public PocoDatabaseImpl {

	public:

		SQLiteDatabase (const string& connect, bool verbose, bool fast);

	virtual string GetVersion () const throw (Xception);
};
#endif

#ifdef USE_MYSQL
//=== MySQLDatabase ========================================================
class MySQLDatabase: public PocoDatabaseImpl {

	public:

		MySQLDatabase (const string& connect, bool verbose, bool fast);

	virtual string GetVersion () const throw (Xception);
};
#endif

#endif
