// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DB_IMPL_H
#define __DB_IMPL_H

#include "db.h"
#include "../libpdrx/poco_db.h"

//=== PocoDatabaseImpl (abstract base class) ===============================
class PocoDatabaseImpl: public Database, public PocoDatabase {

	protected:

		PocoDatabaseImpl (const string& connect, bool verbose, const string& KEY, Poco::Data::Connector* pConnector);

	public:

	virtual	~PocoDatabaseImpl ();

	protected:

	virtual void CreateCollectionInSchema (const string& name, char type, const string& tblname) throw (Xception) =0;
	virtual void DropCollectionFromSchema (const string& tblname) throw (Xception) =0;
	virtual void InsertOrUpdateCollectionItem (const CollectionMetaInfo& cmi, const CollectionItem& item) =0;

		string GetNewTblname () const;
		char GetCollectionTypeFromValue (const any& a) const;

	public:

	virtual	void Connect () throw (Xception);

	virtual void ListCollections () throw (Xception);
	virtual	void AddCollection (const string& name) throw (Xception);
	virtual	void DeleteCollection (const string& name) throw (Xception);
	virtual	void DeleteAllCollections () throw (Xception);
	virtual	void ListRejections () throw (Xception);
	virtual	void AddRejected (const ptime& timestamp, const string& expr) throw (Xception);
	virtual	void DeleteAllRejections () throw (Xception);

	virtual	char GetCollectionType (const string& name) const throw (Xception);
	virtual void GetCollections (Collections& collections) const throw (Xception);
	virtual void GetCollectionItems (const string& name, CollectionItems& items) const throw (Xception);
	virtual	void AddCollectionsItems (const CollectionsItems& items) throw (Xception);
	virtual void DeleteCollectionsItems (const ptime& timestamp, const Collections& collections);

	virtual void GenerateExpressions (Expressions& expressions, const ptime& timestamp) const throw (Xception);
};

#ifdef USE_SQLITE
//=== SQLiteDatabase =======================================================
class SQLiteDatabase: public PocoDatabaseImpl {

	public:

		SQLiteDatabase (const string& connect, bool verbose);

	protected:

	virtual	void NoSchemaCallback () throw (Xception);

	virtual void CreateCollectionInSchema (const string& name, char type, const string& tblname) throw (Xception);
	virtual void DropCollectionFromSchema (const string& tblname) throw (Xception);
	virtual void InsertOrUpdateCollectionItem (const CollectionMetaInfo& cmi, const CollectionItem& item);
};
#endif

#ifdef USE_MYSQL
//=== MySQLDatabase ========================================================
class MySQLDatabase: public PocoDatabaseImpl {

	public:

		MySQLDatabase (const string& connect, bool verbose);

	protected:

	virtual	void NoSchemaCallback () throw (Xception);

	virtual void CreateCollectionInSchema (const string& name, char type, const string& tblname) throw (Xception);
	virtual void DropCollectionFromSchema (const string& tblname) throw (Xception);
	virtual void InsertOrUpdateCollectionItem (const CollectionMetaInfo& cmi, const CollectionItem& item);
};
#endif

#endif
