// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __IN_H
#define __IN_H

//=== Input (abstract base class) ==========================================
//
// This is the base class for an input. An input gets informations from the
// outer world (from mail, command line, file import ...) and inserts them
// into the database. All action is done in the Do() method.
//
class Input {

	public:

	virtual ~Input ();

	virtual	void Do (const Config& config, Database& database) const throw (Xception) =0;
};

//=== InputFactory =========================================================
//
// This factory manages a vector of concrete input objects according to the
// input specifications made in the configuration file. After creation the
// vector can be iterated over to get the Do() methods of the input objects
// called one by one.
//
class InputFactory {

	public:

	typedef vector<Input*> Inputs;

	protected:

	Inputs		m_inputs;
	bool		m_initialized;

	public:

		InputFactory ();
	virtual	~InputFactory ();

	const Inputs& GetInputs (const Config& config) throw (Xception);
	Input* GetInputInteractive () throw (Xception);
};

#endif
