// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DIAGRAM_H
#define __DIAGRAM_H

//=== Diagram (abstract base class) ========================================
class Diagram {

	public:

	enum XUnit {
		years,
		months,
		days,
		hours,
		minutes,
		seconds
	};

	enum FoldInterval {
		year,
		month,
		day,
		hour,
		minute
	};

	enum LineStyle {
		zigzag,
		bars,
		symbol_plus,
		symbol_vbar,
		symbol_hbar,
		symbol_cross,
		symbol_circle
	};

	virtual	~Diagram ();

	virtual	void OpenCanvas (size_t width, size_t height, RGB bgColor) =0;
	virtual	void CloseCanvas () =0;

	virtual	void DrawAxes (const ptime& x_min, const ptime& x_max, XUnit x_unit, double y_min, double y_max, double y_unit, RGB color) =0;
	virtual	void DrawAxes (FoldInterval fi, double y_min, double y_max, double y_unit, RGB color) =0;
	virtual	void DrawCurve (const Selection& s, RGB color, LineStyle style, double thickness, bool continuous, int bar1, int bar2) =0;
	virtual	void DrawVLine (const ptime& timestamp, RGB color, double thickness) =0;
	virtual	void DrawVLine (const time_duration& time, RGB color, double thickness) =0;
	virtual	void DrawHLine (double value, RGB color, double thickness) =0;

	virtual void SaveAs (const string& filename) const =0;

	static ptime CompletePtimeFromString (const string& s);
};

//=== DiagramFactory =======================================================
class DiagramFactory {

	public:

	static Diagram* Create (const string& filename, bool antialias) throw (Xception);
};

#endif
