// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __COMMON_H
#define __COMMON_H

#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <set>
#include <map>
#include <algorithm>

#include <boost/program_options/cmdline.hpp>
#include <boost/program_options/parsers.hpp>
#include <boost/program_options/options_description.hpp>
#include <boost/program_options/variables_map.hpp>

#include <boost/regex.hpp>
#include <boost/tokenizer.hpp>
#include <boost/format.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/date_time/gregorian/gregorian.hpp>
#include <boost/any.hpp>
#include <boost/algorithm/string/trim.hpp>
#include <boost/foreach.hpp>
#include <boost/filesystem.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/multi_array.hpp>
#include <boost/shared_ptr.hpp>

#define foreach			BOOST_FOREACH

#define	RX_COLLECTION_NAME	"[A-Za-z_*+!?^$&\\[\\]\\{\\}=~]+"

#define	VERSION			"0.3.5"

namespace boost {

	template<> inline std::string lexical_cast (const boost::posix_time::ptime& arg)
	{
		std::string s(boost::posix_time::to_iso_extended_string(arg));
		if (s[0] != 'n') // "not_a_date_time"
		{
			s[10] = ' '; // replace 'T'
			s.erase(19); // cut milliseconds
		}
		return s; // --> YYYY-MM-DD hh:mm:ss
	}

	template<> inline boost::posix_time::ptime lexical_cast (const std::string& arg)
	{
		std::string s(arg); // --> YYYY-MM-DD hh:mm:ss
		s[10] = 'T';
		s.erase(4, 1); // '-'
		s.erase(6, 1); // '-'
		s.erase(11, 1); // ':'
		s.erase(13, 1); // ':'
		return boost::posix_time::from_iso_string(s);
	}

	template<> inline boost::gregorian::date lexical_cast (const std::string& arg)
	{
		boost::gregorian::date d = boost::gregorian::from_string(arg);
		return d;
	}

	template<> inline std::string lexical_cast (const boost::gregorian::date& arg)
	{
		std::string s(boost::gregorian::to_iso_extended_string(arg));
		return s;
	}

	template<> inline std::string lexical_cast (const boost::posix_time::time_duration& arg)
	{
		std::string s(boost::posix_time::to_simple_string(arg));
		std::string::size_type pos = s.find('.');
		if (pos != std::string::npos)
			s.erase(pos); // cut milliseconds
		return s;
	}

	// template<> inline Ratio lexical_cast (const std::string& arg)
	// look into datatypes.h
}

#endif
