// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DB_H
#define __DB_H

//=== Database (abstract base class) =======================================
//
// This is the base class for all database classes.
//
class Database {

	public:

	// input data from input sources
	struct CollectionElement {
		string m_name; // of collection
		ptime m_timestamp;
		any m_data;
		CollectionElement (const string& name, const ptime& timestamp, const any& data)
			: m_name(name)
			, m_timestamp(timestamp)
			, m_data(data)
		{
		}
	};

	typedef vector<CollectionElement> CollectionElements;

	virtual	~Database ();

	virtual	void ListCollections () throw (Xception) =0;
	virtual	void AddCollection (const string& name) throw (Xception) =0;
	virtual	void DeleteCollection (const string& name) throw (Xception) =0;
	virtual	void DeleteAllCollections () throw (Xception) =0;
	virtual char GetCollectionType (const string& name) throw (Xception) =0;

	virtual	void ListRejections () throw (Xception) =0;
	virtual	void DeleteAllRejections () throw (Xception) =0;

	virtual	void AddCollectionElements (const CollectionElements& elements) throw (Xception) =0;
	virtual	void AddInserted (const ptime& timestamp, const string& expr) throw (Xception) =0;
	virtual	void AddRejected (const ptime& timestamp, const string& expr) throw (Xception) =0;
};

//=== DBFactory ============================================================
//
// This factory creates one concrete database object according to the
// database specifications made in the configuration file. If Create()
// doesn't throw an exception the database object will immediately be
// connected and ready for use. The user should delete the object.
//
class DBFactory {

	public:

	static Database* Create (const Config& config) throw (Xception);
};

#endif
