// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __CONFIG_H
#define __CONFIG_H

//=== Config ===============================================================
class Config {

	protected:

	options_description		m_od1;	// the official parameters
	options_description		m_od2;	// the hidden parameter (the sum of all tokens on the cmd line)
	positional_options_description	m_pod;
	variables_map			m_vm;
	ptime				m_now;

	public:

		Config ();
	virtual	~Config ();

	virtual	void	Init (int argc, char* argv[]) throw (Xception);
	virtual void	ModifyCmdLineOptions (parsed_options& po);

	void		Help (ostream& os) const;

	bool		HasOption (const string& option) const;
	bool		GetBoolOption (const string& option) const;
	string		GetStringOption (const string& option) const;
	double		GetDoubleOption (const string& option) const;
	vector<string>	GetVectorOption (const string& option) const;
	string		GetFilenameOption (const string& option) const;

	ptime		GetNow () const;
};

//=== ConfigFactory ========================================================
template<class T> class ConfigFactory {

	public:

	static T* Create (int argc, char* argv[]) throw (Xception)
	{
		auto_ptr<T> config(new T());
		config->Init(argc, argv);
		return config.release();
	}
};

#endif
