#!/bin/sh
###############################################################################
# $Id: testdeps.sh,v 1.1 2005/08/28 20:00:36 killabyte Exp $
#
# Test backend dependency resolution algorithms.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

# Initialize test script...
. ./init.sh

# Set env vars
DEL_FILES="test.cfg test.log be.cfg"
DI_CFG_FILE="./test.cfg"

export DI_CFG_FILE

###############################################################################
# TEST
###############################################################################

# Create the test config file
cat > test.cfg<<EOF
verbose = 3
no_check_on_config = true
logfile = ./test.log
config = ./be.cfg
EOF

# Create a fake commands file
touch be.cfg

# Execute test
LD_LIBRARY_PATH="../link/" ./testdeps
RET=$?

# Remove temporary files and exit
if [ $RET -eq 0 ]; then
  rm -f $DEL_FILES
fi

exit $RET
