/*****************************************************************************
 * $Id: testdeps.c,v 1.1 2005/08/28 20:00:57 killabyte Exp $
 *
 * Test program that checks the backend dependency resolution mechanism.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<beconfig.h>
#include<log.h>

typedef struct _tag_BDEP {
  char *name[10];
} BDEP;

typedef struct _tag_TESTCONFIG {
  char *name;
  char *objects[20];
} TESTCONFIG;

typedef struct _tag_TEST {
  int n;
  int res;
  TESTCONFIG config[20];
  BDEP final_list[40];
} TEST;

TEST tests[] = {
  { 1, 0, { { "test1_1", { "A", "B", "C", "D", "E" } } },
       { {{ "A" }},
         {{ "B" }},
         {{ "C" }},
         {{ "D" }},
         {{ "E" }} } },
  { 3, 0, { { "test2_1", { "A", "B" } },
            { "test2_2", { "C", "D" } },
            { "test2_3", { "E", "F" } } },
       { {{ "A", "C", "E" }},
         {{ "B", "D", "F" }} } },
  { 2, 0, { { "test3_1", { "A", "B", "C" } },
            { "test3_2", { "C", "D", "E" } } },
       { {{ "A" }},
         {{ "B" }},
         {{ "C" }},
         {{ "D" }},
         {{ "E" }} } },
  { 3, 0, { { "test2_1", { "A", "C"      } },
            { "test2_2", { "B", "D", "E" } },
            { "test2_3", { "B", "C"      } } },
       { {{ "A" }},
         {{ "B" }},
         {{ "C" }},
         {{ "D" }},
         {{ "E" }} } }
};

/*
BECFG_OBJ_INFO *_pdi_becfg_getObject(BECFG_CONFIG *cfg, char *x);
*/

int main(int argc, char **argv)
{
  BECFG_CONFIG *cfg_final, *cfg;
  BECFG_OBJ_INFO *bo;
  char name[200];
  char **s;
  int i, j, k, fin, balance;

  for(i = 0; i < sizeof(tests) / sizeof(TEST); i++)
  {
    sprintf(name, "TEST-FINAL-%d", i);
    _pdi_debug(THIS, "%d:Testing '%s'.", i, name);
    if((cfg_final = _pdi_becfg_newConfig(name)) == NULL)
    {
      _pdi_error(THIS, "%d:Failed in '_pdi_becfg_newConfig()'.", i);
      exit(-1);
    }

    fin = 0;

    _pdi_debug(THIS, "%d:I am going to mix %d config files.", i, tests[i].n);
    for(j = 0; !fin && j < tests[i].n; j++)
    {
      _pdi_debug(THIS, "%d:%d:Creating config.", i, j);
      sprintf(name, "test-%d_%d", i, j);
      if((cfg = _pdi_becfg_newConfig(name)) == NULL)
      {
        _pdi_error(THIS, "%d:Error in '_pdi_becfg_newConfig()'.", i);
        exit(-1);
      }

      for(s = tests[i].config[j].objects; *s; s++)
      {
        if(!_pdi_becfg_addObject(cfg, *s, NULL, 1))
        {
          _pdi_error(THIS, "'_pdi_becfg_addObject()' failed.", i);
          exit(-1);
        }
      }

      if(_pdi_becfg_mergeBackendConfigFiles(cfg_final, cfg) && !tests[i].res)
      {
        _pdi_error(THIS, "%d:Dependency test have failed!", i);
        exit(-1);
      } else
        if(tests[i].res)
          fin = -1;

      _pdi_becfg_showObjects(3, cfg_final);
      _pdi_becfg_destroyConfig(cfg);
    }

    if(fin)
    {
      if(tests[i].res)
      {
        _pdi_error(THIS, "%d:Dependency test should have failed!", i);
        exit(-1);
      }
      _pdi_debug(THIS, "%d:Fail accepted.", i);
    } else {
      _pdi_debug(THIS, "%d:I am going to compare.", i);
      j = 0;
      balance = 0;
      for(bo = cfg_final->bc_objlist; bo; bo = bo->co_next)
      {
        if(strcmp(PDI_ALIAS_LIBC, _pdi_becfg_getObjectName(bo))
        && strcmp(PDI_ALIAS_MAIN, _pdi_becfg_getObjectName(bo))
        && strcmp(PDI_ALIAS_PDI, _pdi_becfg_getObjectName(bo)))
        {
          balance++;
          for(fin = 0; !fin && tests[i].final_list[j].name[0]; )
          {
            for(k = 0; !fin && tests[i].final_list[j].name[k]; )
            {
              _pdi_debug(THIS, "%d:Comparing '%s' with '%s'.",
                         i, tests[i].final_list[j].name[k], _pdi_becfg_getObjectName(bo));
              if(!strcmp(tests[i].final_list[j].name[k], _pdi_becfg_getObjectName(bo)))
              {
                _pdi_debug(THIS, "%d:Found '%s' with deep %d.",
                         i, tests[i].final_list[j].name[k], j);
                fin = -1;
                balance--;
              }
              if(!fin)
                k++;
            }
            if(!fin)
              j++;
          }
          if(!fin)
          {
            _pdi_error(THIS, "%d:Final lists differ.", i);
            exit(-1);
          }
        }
      }

      if(balance)
      {
        _pdi_error(THIS, "%d:Lists differ in element quantity.", i);
        exit(-1);
      }
      _pdi_debug(THIS, "%d:End of comparison.", i);
    }

    _pdi_becfg_destroyConfig(cfg_final);
  }

  exit(0);
}
