#!/bin/sh
###############################################################################
# $Id: testcfg03fe.sh,v 1.1 2005/08/28 20:06:49 killabyte Exp $
#
# Check if are correctly resolved conflicts between config files and
# environment variables.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

# Initialize test script...
. ./init.sh

# Set env vars
LD_LIBRARY_PATH="../link/"

DEL_FILES="test.cfg cfg_config.cfg cfg_runtime.cfg env_config.cfg env_runtime.cfg test.log test.out"

DI_LOG_FILE="test.log"
DI_CFG_FILE="./test.cfg"
DI_BASE_PATH="env_basepath"
DI_FEEDBACK="ON"
DI_CONFIG_FILE="env_config.cfg"
DI_RUNTIME_FILE="env_runtime.cfg"

export LD_LIBRARY_PATH DI_LOG_FILE DI_CFG_FILE DI_BASE_PATH DI_FEEDBACK DI_CONFIG_FILE DI_RUNTIME_FILE

###############################################################################
# FIRST TEST
###############################################################################

# Create a test config file
cat > test.cfg<<EOF
verbose = 3
config =   cfg_config.cfg
reset_runtime
runtime =  cfg_runtime.cfg
EOF

# Create fake commands files
touch cfg_runtime.cfg env_config.cfg cfg_config.cfg

# Execute test 1
./testcfg03a > "test.out" 2>&1
if [ $? -ne 0 ]; then
  exit 1
fi

###############################################################################
# SECOND TEST
###############################################################################

# Create a test config file
cat > test.cfg<<EOF
EOF

# Create a fake commands file
touch env_runtime.cfg

# Execute test 2
./testcfg03b > "test.out" 2>&1
if [ $? -ne 0 ]; then
  exit 1
fi

# Remove temporary files and exit
rm -f $DEL_FILES
exit 0
