#!/bin/sh
###############################################################################
# $Id: testcfg02env.sh,v 1.1 2005/08/28 20:06:26 killabyte Exp $
#
# Check that env vars are readed correctly.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

# Initialize test script...
. ./init.sh

# Stablish env vars
LD_LIBRARY_PATH=../link/

DEL_FILES="test.cfg test.log runtime_file.cfg config_file.cfg test.out"

DI_CFG_FILE=
DI_FEEDBACK=ON
DI_CONFIG_FILE="./config_file.cfg"
DI_RUNTIME_FILE="./runtime_file.cfg"
DI_LOG_FILE="./test.log"

export LD_LIBRARY_PATH DI_CFG_FILE DI_FEEDBACK DI_CONFIG_FILE DI_RUNTIME_FILE DI_LOG_FILE

# Create fake commands files
echo > ./runtime_file.cfg
echo > ./config_file.cfg

# Execute test
./testcfg02a > "test.out" 2>&1
if [ $? -ne 0 ]; then
  exit 1
fi

# Remove temporary files and exit
rm -f $DEL_FILES
exit 0
