#!/bin/sh
###############################################################################
# $Id: testcfg01file.sh,v 1.1 2005/08/28 20:06:11 killabyte Exp $
#
# Check that config files of pDI-Tools are interpretated properly.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

# Initialize test script...
. ./init.sh

# Set env vars
LD_LIBRARY_PATH="../link/"
DEL_FILES="test.cfg test.log test.out be.cfg"
DI_CFG_FILE="./test.cfg"
export LD_LIBRARY_PATH DI_CFG_FILE

###############################################################################
# FIRST TEST
###############################################################################

# Create a test config file
cat > test.cfg<<EOF
# Global parameters
[global]
verbose = 2
logfile = ./test.log
Include :$PLATFORM_ID

[$PLATFORM_ID]
config = ./be.cfg
runtime =
debug = true

[otherplatform]
config = other_config
runtime = other_runtime
EOF

# Create a fake commands file
echo > be.cfg

# Execute test 1
./testcfg01a > test.out 2>&1
if [ $? -ne 0 ]; then
  echo Error in TEST-A
  exit 1
fi

###############################################################################
# SECOND TEST
###############################################################################

# Create a test config file
cat > test.cfg<<EOF
verbose = 3
logfile = ./test.log

[global]
# More global parameters
config = ./be.cfg
runtime =
debug = 1
EOF

# Execute test 2
./testcfg01b >> test.out 2>&1
if [ $? -ne 0 ]; then
  echo Error in TEST-B
  exit 1
fi

###############################################################################
# THIRD TEST
###############################################################################

# Create a test config file
cat > test.cfg<<EOF
[otherplatform]
# More global parameters
config = ./be.cfg
runtime =
debug = 1
[global]
verbose = 3
logfile = ./test.log

EOF

# Execute test 3
./testcfg01c >> test.out 2>&1
if [ $? -ne 0 ]; then
  echo Error in TEST-C
  exit 1
fi

# Remove temporary files and exit
rm -f $DEL_FILES
exit 0
