#!/bin/sh
###############################################################################
# $Id: testcallback.sh,v 1.1 2005/08/28 20:05:57 killabyte Exp $
#
# Check that callback interpositions are working correctly.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

# Initialize env vars...
. ./init.sh

LD_LIBRARY_PATH=".:../link/"
DEL_FILES="test.cfg test.log be.cfg test.tmp test.ok"
DI_CFG_FILE="./test.cfg"

export LD_LIBRARY_PATH DI_CFG_FILE

###############################################################################
# CHECK CALLBACK!
###############################################################################

# Now we create a config file
cat > test.cfg<<EOF
verbose = 3
debug = off
logfile = ./test.log
config = ./be.cfg
EOF

# This file explains how to install this callback
cat > be.cfg<<EOF
#backend BACKEND callback.so
#commands
C MAIN * BACKEND
EOF

# This test should create a file with this content:
echo -n "+.+.+.+.+.+.+.+.+.+." > test.ok

# Do test!
./launchpdi.sh "./simple" 2>&1 > /dev/null
if [ $? -ne 0 ]; then
  exit 1
fi

if ! diff test.tmp test.ok; then
  exit 1
fi

# Remove temporary files and exit
rm -f $DEL_FILES
exit 0
