/*****************************************************************************
 * $Id: simple.c,v 1.1 2005/08/28 19:59:34 killabyte Exp $
 *
 * Silly test program.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>

int main(int argc, char **argv)
{
  int i;
  int ret;
  void *oh;
  void (*my_exit)(int x);

  /* If there is a parameter it will be our exit value, 0 otherwise */
  ret = argc > 1 ? atoi(argv[1]) : 0;

  /* Print ten 'Y' in standard output with 'fputc()' */
  for(i = 0; i < 10; i++)
    if(fputc('Y', stdout) != 'Y')
      exit(1);

  /* Open test lib and call 'my_exit()' with 'ret' as exit value */
  if((oh = dlopen("libtest.so", RTLD_LAZY)) == NULL)
  {
    fprintf(stderr, "Cannot open 'libtest.so'.\n");
    exit(1);
  }

  if((my_exit = dlsym(oh, "my_exit")) == NULL)
  {
    fprintf(stderr, "Cannot find 'my_exit()' in 'libtest.so'.\n");
    exit(1);
  }

  my_exit(ret);

  exit(1);
}

