#!/bin/sh
###############################################################################
# $Id: launchpdi.sh,v 1.1 2005/08/28 19:59:10 killabyte Exp $
#
# This file uses the correct syntax to launch pDI-Tools in each platform.
#
# -----------------------------------------------------------------------------
# pDI-Tools - portable Dynamic Instrumentation Tools
#   (C) 2004, 2005 Gerardo Garca Pea
#   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#   USA
#
###############################################################################

case $PLATFORM_OS in
  PDI_OS_IRIX)
    _RLD_LIST="../link/libpdi.so:DEFAULT" $*
    ;;
  PDI_OS_LINUX)
    LD_PRELOAD="../link/libpdi.so" $*
    ;;
  PDI_OS_SOLARIS)
    LD_PRELOAD="../link/libpdi.so" $*
    ;;
  *)
    echo "I don't know how to run a test in this operating system: $PLATFORM_OS"
    exit 1
esac

exit $?
