/*****************************************************************************
 * $Id: chkconfig.h,v 1.1 2005/08/28 20:04:30 killabyte Exp $
 *
 * Macros to make tests on pDI-Tools.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#ifndef __CHKCONFIG_H__
#define __CHKCONFIG_H__

#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#include<config.h>
#include<pdiconfig.h>

#define INIT_TEST           failed = NULL; type = 0;
#define SHOULD_BE_STR(x,y)  if(((y) != PDICFG.x)                              \
                            && (!(y) || !PDICFG.x || strcmp(PDICFG.x, y)))    \
                            {                                                 \
                              type = 1;                                       \
                              failed = #x;                                    \
                              vals.str.configured = PDICFG.x;                 \
                              vals.str.expected = (y);                        \
                            }
#define SHOULD_BE_INT(x,y)  if(PDICFG.x != (y))                               \
                            {                                                 \
                              type = 0;                                       \
                              failed = #x;                                    \
                              vals.val.configured = PDICFG.x;                 \
                              vals.val.expected = (y);                        \
                            }
#define SHOULD_BE_TAB(x,y)  if(PDICFG.x)                                      \
                            {                                                 \
                              char *s;                                        \
                              char **s2;                                      \
                                                                              \
                              for(s = y, s2 = PDICFG.x;                       \
                                  !failed && *s2 && strlen(s);                \
                                  s += strlen(s) + 1, s2++)                   \
                              {                                               \
                                if(strcmp(s, *s2))                            \
                                {                                             \
                                  type = 1;                                   \
                                  failed = #x;                                \
                                  vals.str.configured = *s2;                  \
                                  vals.str.expected = s;                      \
                                }                                             \
                              }                                               \
                              if(!failed && (strlen(s) || *s2))               \
                              {                                               \
                                type = 1;                                     \
                                failed = #x;                                  \
                                vals.str.configured = *s2 ? *s2 : "(none)";   \
                                vals.str.expected = strlen(s) ? "(none)" : s; \
                              }                                               \
                            } else {                                          \
                              if(strlen(y))                                   \
                              {                                               \
                                type = 1;                                     \
                                failed = #x;                                  \
                                vals.str.configured = "(none)";               \
                                vals.str.expected = y;                        \
                              }                                               \
                            }

#define SHOULD_BE_ON(x)     if(!PDICFG.x)                                     \
                            {                                                 \
                              type = 0;                                       \
                              failed = #x;                                    \
                              vals.val.configured = PDICFG.x;                 \
                              vals.val.expected = -1;                         \
                            }
#define SHOULD_BE_OFF(x)    if(PDICFG.x)                                      \
                            {                                                 \
                              type = 0;                                       \
                              failed = #x;                                    \
                              vals.val.configured = PDICFG.x;                 \
                              vals.val.expected = 0;                          \
                            }
#define FINI_TEST           status = failed ? 1 : 0;                          \
                            if(failed)                                        \
                            {                                                 \
                              if(type)                                        \
                                fprintf(stderr,                               \
                                        "Parameter '%s' failed:\n"            \
                                        "  expected   = '%s'\n"               \
                                        "  configured = '%s'\n",              \
                                        failed,                               \
                                        vals.str.expected                     \
                                          ? vals.str.expected                 \
                                          : "(null)",                         \
                                        vals.str.configured                   \
                                          ? vals.str.configured               \
                                          : "(null)");                        \
                              else                                            \
                                fprintf(stderr,                               \
                                        "Parameter '%s' failed:\n"            \
                                        "  expected   = '%d'\n"               \
                                        "  configured = '%d'\n",              \
                                        failed,                               \
                                        vals.val.expected,                    \
                                        vals.val.configured);                 \
                            }                                                 \
                            exit(status);
#define BEGIN_MAIN          int main(int argc, char **argv)                   \
                            {                                                 \
                              char *failed;                                   \
                              int type, status;                               \
                              union {                                         \
                                struct { char *configured, *expected; } str;  \
                                struct { int  configured, expected; } val;    \
                              } vals;
#define END_MAIN            }

#endif
