/*****************************************************************************
 * $Id: callback.c,v 1.1 2005/08/28 20:04:14 killabyte Exp $
 *
 * Test backend with a callback handler.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<stdio.h>
#include<unistd.h>
#include<backend.h>

#define TMPFILE         "test.tmp"
#define TRUE            (1==1)
#define FALSE           (1!=1)

static FILE *fout;

int PDI_BE_FUNC_INIT(void)
{
  if((fout = fopen(TMPFILE, "w")) == NULL)
  {
    fprintf(stderr, "%s:Error creating file '%s'.\n", __FILE__, TMPFILE);
    return FALSE;
  }

  return TRUE;
}

void PDI_BE_FUNC_FINI(void)
{
  fclose(fout);
}

int PDI_BE_FUNC_CB_REQ(char *funcname)
{
  return !strcmp("fputc", funcname);
}

void PDI_BE_FUNC_PRE_CB(int virtual_processor, int event_id, ...)
{
  fputc('+', fout);
}

void PDI_BE_FUNC_POST_CB(int virtual_processor, int event_id, int retval)
{
  fputc('.', fout);
}

