/*****************************************************************************
 * $Id: testpdi.c,v 1.3 2005/09/07 21:49:04 killabyte Exp $
 *
 * This is a little and simple test program easy to instrument. It is used to
 * test and debug pDI-Tools.
 *
 *   NOTE: It is a Bad Idea (TM) to compile this code with optimizations.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<dlfcn.h>

int lib_function(void);

int main_func(void)
{
  printf("I AM THE FUNC!\n");
  return 0;
}

int main(int argc, char **argv)
{
  void *libdyn;
  int (*libdyn_func)(void);

  /* Hacemos el tonto con fputc */
  fputc('+', stdout);
  if(fputc('*', stdout) != (int) '*')
    printf("\nFunction 'fputc()' DOESN'T WORK WEEEEELLLLLLLL!\n");
  else
    printf("\nFunction 'fputc()' seems to work well.\n");

  /* Hacemos el tonto con printf */
  printf("kakakakakakakakakaakakakaka.\n");

  /* Llamamos a una funcin de nuestra librera */
  lib_function();

  /* Por ltimo cargamos una librera, y llamamos a una funcin suya */
#if PDI_REDEFINES_ENABLED
  if((libdyn = dlopen("./libdyn.so", RTLD_LAZY)) == NULL)
  {
    fprintf(stderr, "Error trying to open 'libdyn.c':%s\n",
            dlerror());
    exit(1);
  }
  if((libdyn_func = dlsym(libdyn, "libdyn_test")) == NULL)
  {
    fprintf(stderr, "Cannot find symbol 'libdyn.c::libdyn_func()':%s\n",
            dlerror());
    exit(1);
  }
  
  libdyn_func();

  dlclose(libdyn);
#endif

  /* Salimos */
  /* NOTA: Instrumentar esta funcin es una Mala Idea (TM). Motivo: es */
  /* una funcin que no vuelve, as que gcc(1) hace las optimizaciones */
  /* pertinentes en base a eso... resultado: si se instrumenta exit(2) */
  /* pasan Cosas Curiosas (TM) de verdad                               */
  exit(0);
}

