/*****************************************************************************
 * $Id: testcb.c,v 1.2 2005/08/23 12:12:29 killabyte Exp $
 *
 * Test backend with a callback handler.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<stdio.h>
#include<unistd.h>
#include<backend.h>

#define TRUE (1==1)

/* Lista de funciones que procesar el callback */
char *funcs[] = { "__libc_start_main", "fputc", "printf", "fprintf", "tell", "puts", NULL };

int PDI_BE_FUNC_INIT(void)
{
  printf("Initializing backend.\n");
  return TRUE;
}

void PDI_BE_FUNC_FINI(void)
{
  printf("Closing backend.\n");
}

int PDI_BE_FUNC_CB_REQ(char *funcname)
{
  int i;

  printf("Try to identify: '%s'\n", funcname);
  for(i = 0; funcs[i]; i++)
    if(!strcmp(funcname, funcs[i]))
      return i+1;

  return 0;
}

void PDI_BE_FUNC_PRE_CB(int virtual_processor, int event_id, ...)
{
  printf("We are going to call '%s'\n", funcs[event_id-1]);
}

void PDI_BE_FUNC_POST_CB(int virtual_processor, int event_id, int retval)
{
  printf("The function '%s' returns %d.\n", funcs[event_id-1], retval);
}

