/*****************************************************************************
 * $Id: testbe.c,v 1.2 2005/08/23 12:12:29 killabyte Exp $
 *
 * Simple test backend.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<backend.h>

#define TRUE (1==1)

/* Variables privadas del mdulo (contadores) */
static int read_no;
static int write_no;

/*****************************************************************************
 * WRAPPERS
 *
 *   Las siguientes funciones se utilizarn para instrumentar otras funciones.
 *
 *****************************************************************************/

ssize_t read_wrapper(int fd, void *buf, size_t nbyte)
{
  ++read_no;
  write(0, "read()\n", 7);
  return read(fd, buf, nbyte);
}

ssize_t write_wrapper(int fd, const void *buf, size_t nbyte)
{
  ++write_no;
  write(0, "write()\n", 8);
  return write(fd, buf, nbyte);
}

int fputc_wrapper(int c, FILE *f)
{
  printf("polla polla = (%d) = '%c'.\n", c, c);
  fputc('-', stdout);
  fputc('-', stdout);
  fputc('h', stdout);
  fputc('o', stdout);
  fputc('l', stdout);
  fputc('a', stdout);
  fputc('\n', stdout);
  return c;
}

int lib_function_wrapper(void)
{
  printf("WRAPEIPOS IN DA MORNIN!\n");
  return 0;
}

/*****************************************************************************
 * INICIALIZACIN Y FINALIZACIN DEL BACKEND
 *
 *   Acto seguido vienen di_init_backend() y di_fini_backend(). Estas
 *   funciones son llamadas por pDI-Tools durante la inicializacin y la
 *   finalizacin del programa, respectivamente.
 *
 *****************************************************************************/

int PDI_BE_FUNC_INIT(void)
{
  printf("Initializing backend '" __FILE__ "'.\n");
  read_no = write_no = 0;
  return TRUE;
}

void PDI_BE_FUNC_FINI(void)
{
  printf("Closing backend '" __FILE__ "'.\n"
         "  number of reads  = %d\n"
         "  number of writes = %d\n", read_no, write_no);
}

/*****************************************************************************
 * GESTIN DE LOS CALLBACKS DEL BACKEND
 *
 *   Lo que viene ahora son las funciones necesarias para que el backend pueda
 *   interceptar llamadas a libreras mediante callbacks.
 *
 *****************************************************************************/

int PDI_BE_FUNC_CB_REQ(char *func)
{
#define EV_FPUTC  1
#define EV_PRINTF 2
#define EV_PUTS   3
  struct {
    char   *func;
    int    id;
  } funcs[] = { { "fputc",  EV_FPUTC  },
                { "printf", EV_PRINTF },
                { "puts",   EV_PUTS   },
                { NULL,     0         } };
  int i;

  for(i = 0; funcs[i].func; i++)
    if(!strcmp(func, funcs[i].func))
    {
      printf("di_callback_required():@func = 0x%08lx\n", (unsigned long) func);
      printf("di_callback_required():func = '%s'\n", func);
      return funcs[i].id;
    }

  return 0;
}

void PDI_BE_FUNC_PRE_CB(int virtual_processor, int event_id, ...)
{
  va_list ap;
  int c;
  char *s;
  FILE *f;

  va_start(ap, event_id);

  switch(event_id)
  {
    case EV_FPUTC:
      c = va_arg(ap, int);
      f = va_arg(ap, FILE *);
      printf("PRE:%d: fputc('%c', 0x%08lx)\n",
             virtual_processor, c, (unsigned long) f);
      break;
    case EV_PRINTF:
      s = va_arg(ap, char *);
      printf("PRE:%d: printf(\"%s\", ...)\n", virtual_processor, s);
      break;
    case EV_PUTS:
      s = va_arg(ap, char *);
      printf("PRE:%d: puts(\"%s\")\n", virtual_processor, s);
      break;
    default:
      printf("PRE:%d: UNKNOWN CASE %d!!\n", virtual_processor, event_id);
  }

  va_end(ap);

}

void PDI_BE_FUNC_POST_CB(int virtual_processor, int event_id, int retval)
{
  printf("POST:%d: event_id=%d, retval=%d]\n", virtual_processor, event_id, retval);
}

