/*****************************************************************************
 * $Id: sl-symtab.c,v 1.1 2005/08/28 19:06:41 killabyte Exp $
 *
 * Functions to work on symbol table of objects in memory.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<solaris/elfops.h>

/*****************************************************************************
 * ElfW(Sym) *_pdi_solaris_getSymbolTableEntry(PDI_SOLARIS_ELFOBJ *obj,
 *                                             char *name,
 *                                             unsigned int *symndx)
 *
 * Description:
 *   Search symbol 'name' in 'obj' symbol table. It returns a pointer to the
 *   symbol information and its index in symbol table.
 *
 * Parameters:
 *   obj    - object
 *   name   - searched symbol
 *   symndx - (out). Symbol index (if it exists). If this parameter is NULL
 *            nothing will be returned through it.
 *
 * Returns:
 *   A pointer to symbol info, or NULL if the symbol does not exist.
 *
 *****************************************************************************/

ElfW(Sym) *_pdi_solaris_getSymbolTableEntry(PDI_SOLARIS_ELFOBJ *obj,
                                            char *name,
                                            unsigned int *symndx)
{
  unsigned int hash;
  unsigned int si;
  ElfW(Sym) *symptr;

  /* Get the hash of symbol name */
  hash = elf_hash(name);

  /* Search symbol in hash section */
  for(si = obj->l_bucket[hash % obj->n_bucket];
      si != STN_UNDEF;
      si = obj->l_chain[si])
  {
    symptr = (ElfW(Sym) *) (((char *) obj->symbolTable) + (si * obj->symbolSize));
    if(!strcmp(name, ((char *) obj->stringTable) + symptr->st_name))
    {
      /* Symbol found! Returning a pointer to the symbol */
      if(symndx) *symndx = si;
      return symptr;
    }
  }

  /* The symbol does not exist :'( */
  if(symndx) *symndx = STN_UNDEF;

  return NULL;
}

