/*****************************************************************************
 * $Id: sl-resolve.c,v 1.1 2005/08/28 18:30:42 killabyte Exp $
 *
 * Permite resolver un smbolo en el programa en ejecucin.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<log.h>
#include<solaris/elfops.h>

/*****************************************************************************
 * int _pdi_solaris_symbolIsUsedOrReferenced(PDI_ELFOBJ *obj, char *name)
 *
 * Description:
 *   This function tells if symbol 'name' is referenced, implemented or not
 *   used by object 'obj'.
 *
 * Parameters:
 *   obj  - object
 *   name - symbol name
 *
 * Returns:
 *   0 if it is not used nor implemented. Positive value if it is implemented,
 *   or negative value if it is used by.
 *
 *****************************************************************************/

int _pdi_solaris_symbolIsUsedOrReferenced(PDI_ELFOBJ *obj, char *name)
{
  ElfW(Sym) *symptr;

  if(obj->o_arch->broken_dso)
  {
    _pdi_error(THIS, "Cannot operate with '%s'. This object is broken.",
               _pdi_ebe_getObjectName(obj));
    return 0;
  }

  if((symptr = _pdi_solaris_getSymbolTableEntry(obj->o_arch, name, NULL)) == NULL)
    return 0;

  return symptr->st_shndx != 0 ? 1 : -1;
}

/*****************************************************************************
 * void *_pdi_solaris_resolveSymbolInObject(PDI_ELFOBJ *obj, char *name)
 *
 * Description:
 *   Get address of function 'name' in object 'obj'.
 *
 * Parameters:
 *   obj  - object
 *   name - string with function name
 *
 * Returns:
 *   This function returns a pointer to function entry point if it exists, or
 *   NULL otherwise.
 *
 *****************************************************************************/

void *_pdi_solaris_resolveSymbolInObject(PDI_ELFOBJ *obj, char *name)
{
  ElfW(Sym) *symptr;

  if(obj->o_arch->broken_dso)
  {
    _pdi_error(THIS, "Cannot resolve '%s::%s()'. Object is broken.",
               _pdi_ebe_getObjectName(obj), name);
    return NULL;
  }

  if((symptr = _pdi_solaris_getSymbolTableEntry(obj->o_arch, name, NULL)) != NULL
  && symptr->st_shndx != 0)
    return ((void *) (symptr->st_value + obj->o_arch->lm->l_addr));

  return NULL;
}

/*****************************************************************************
 * void *_pdi_solaris_resolveSymbol(char *name)
 *
 * Description:
 *   Search address of function 'name' in objects in memory.
 *
 * Parameters:
 *   name - string with function name
 *
 * Returns:
 *   This function returns a pointer to function entry point if it exists, or
 *   NULL otherwise.
 *
 *****************************************************************************/

void *_pdi_solaris_resolveSymbol(char *name)
{
  PDI_ELFOBJ *obj;
  void *ret;

  for(obj = _pdi_objlist, ret = NULL; !ret && obj; obj = obj->o_next)
    if(!obj->o_arch->broken_dso)
      ret = _pdi_solaris_resolveSymbolInObject(obj, name);

  return ret;
}

