/*****************************************************************************
 * $Id: sl-relink.c,v 1.1 2005/08/28 18:22:43 killabyte Exp $
 *
 * Here is implemented the function '_pdi_arch_relink()' for Solaris which is
 * responsible at low level to install a relink interposition.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<log.h>
#include<solaris/elfops.h>

/*****************************************************************************
 * int _pdi_solaris_relink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
 *
 * Description:
 *   Relinks calls from object 'eo' to some function to another function in a
 *   backend. The interposition parameters are in 'i'.
 *
 * Parameters:
 *   eo - relinked object
 *   i  - relink parameters
 *
 * Returns:
 *   0 if all ok, a negative value otherwise.
 *
 *****************************************************************************/

int _pdi_solaris_relink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
{
  unsigned int symndx;
  ElfW(Sym) *symptr;
  SOLARIS_PLTREL *rel;

  /* Search symbol in the symtab */
  if((symptr = _pdi_solaris_getSymbolTableEntry(eo->o_arch, i->i_symbol, &symndx)) == NULL)
  {
    _pdi_error(THIS, "Cannot find symbol '%s' in '%s'.",
               i->i_symbol, _pdi_ebe_getObjectName(eo));
    return -1;
  }

  /* Search symbol relocation info */
  if((rel = _pdi_solaris_getFunctionRel(eo->o_arch, symndx)) == NULL)
  {
    _pdi_error(THIS, "Cannot find relocation info of '%s::%s()'.",
               _pdi_ebe_getObjectName(eo), i->i_symbol);
    return -1;
  }

  /* Execute relink */
  i->i_arch->u.relink.plt_address =
    _pdi_solaris_alterPlt(eo, rel, i->i_wrapper, i->i_arch->u.relink.orig_code);

  return 0;
}

/*****************************************************************************
 * int _pdi_solaris_undoRelink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
 *
 * Description:
 *   Undo relink interposition 'i' in object 'eo'.
 *
 * Parameters:
 *   eo - relinked object
 *   i  - relink parameters
 *
 * Returns:
 *   0 if all ok, a negative value otherwise.
 *
 *****************************************************************************/

int _pdi_solaris_undoRelink(PDI_ELFOBJ *eo, PDI_INTERCEPT *i)
{
  _pdi_solaris_restorePlt(i->i_arch->u.relink.plt_address,
                          i->i_arch->u.relink.orig_code);

  return 0;
}

