/*****************************************************************************
 * $Id: sl-rdebug.c,v 1.1 2005/08/30 23:23:39 killabyte Exp $
 *
 * This file contains code that gets a pointer to the Runtime Linker's
 * "_r_debug" structure. This structure allows pDI-Tools to access ELF
 * structures in memory on Solaris.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<log.h>

extern ElfW(Dyn) _DYNAMIC;

struct r_debug *_pdi_solaris_r_debug;

int _pdi_solaris_resolveDebugInfoStruct(void)
{
  ElfW(Dyn) *dyn;

  /* Search DT_DEBUG section */
  for(dyn = &_DYNAMIC; dyn->d_tag != DT_NULL && dyn->d_tag != DT_DEBUG; dyn++)
    ;

  if(dyn->d_tag != DT_DEBUG)
  {
    _pdi_error(THIS, "Cannot find DT_DEBUG section.");
    return -1;
  }

  /* La hemos encontrado! Resolvemos '_pdi_solaris_r_debug' */
  if((_pdi_solaris_r_debug = (struct r_debug *) dyn->d_un.d_ptr) == NULL)
  {
    _pdi_error(THIS, "Section DT_DEBUG contains a NULL pointer.");
    return -1;
  }

  return 0;
}

