/*****************************************************************************
 * $Id: sl-alterplt.c,v 1.1 2005/08/25 13:07:44 killabyte Exp $
 *
 * This file implements a mechanism used to alter easily the content of the
 * GOT/PLT tables.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<ebeif.h>
#include<log.h>
#include<solaris/elfops.h>

/*****************************************************************************
 * ElfW(Addr) _pdi_solaris_alterPlt(PDI_ELFOBJ *eo,
 *                                  SOLARIS_PLTREL *rel,
 *                                  void *target,
 *                                  void *orig_code)
 *
 * Description:
 *   Modify the PLT/GOT entry selected by 'symndx' in the object 'eo',
 *   substituting the current pointer by 'target', and saving to 'undo_data'
 *   (if it is not NULL) the current data.
 *
 * Parameters:
 *   eo        - target object
 *   rel       - relocation structure
 *   target    - a pointer to the new definition
 *   orig_code - A pointer to a buffer where save the original PLT code. If
 *               it is NULL the current PLT/GOT info is discarded.
 *
 * Returns:
 *   A pointer to the PLT modified entry.
 *
 *****************************************************************************/

ElfW(Addr) _pdi_solaris_alterPlt(PDI_ELFOBJ *eo,
                                 SOLARIS_PLTREL *rel,
                                 void *target,
                                 void *orig_code)
{
  ElfW(Addr) plt_address;

  /* SPARC relink is HORRIBLE, but it is cool. It is based on the worst     */
  /* thing a friky can do in his/her life: write code on runtime :)______O  */
  /* Steps:                                                                 */
  /*   1 - calculate PLT address where we are going to work                 */
  /*   2 - copy the code there (for undo purposes)                          */
  /*   3 - Supposing we want to relink function 'target()', then we would   */
  /*       write some code of this form:                                    */
  /*          a. sethi (.-.PLT0), %g1                                       */
  /*          b. sethi %hi(target), %g1                                     */
  /*          c. jmpl %g1+%lo(target), %g0                                  */
  /*       Instruccin (a) es easy to forge: it should be there. The rest   */
  /*       is our work, so I will be really the piece of code saved for     */
  /*       undo purposes.                                                   */

  /* 1 - calculate symbol PLT address */
  /*     NOTA: Add base address if it is not the main executable */
  plt_address = rel->r_offset;
  if(eo->o_arch->lm->l_prev)
    plt_address += eo->o_arch->lm->l_addr;

  /* 2 - save the original code in PLT (if 'orig_code' is not NULL) */
  if(orig_code)
    memcpy(orig_code, (void *) plt_address, PDI_SOLARIS_RELINK_CODE_UNDO_SZ);

/* ESTO NOS MUESTRA EL CDIGO EN HEXADECIMAL EN ESE SITIO OSCURO QUE ES
 * EL PLT... SLO APTO PARA VERDADEROS GURUS MASOQUISTAS
 * {
 * int i;
 * for(i = 0; i < 16; i++)
 *   _pdi_debug(THIS, "[0x%08x] inst %02d=0x%08x.", (int *) plt_address + i, i, ((int *) plt_address)[i]);
 * }
 */

  /* 3 - write our bizarre code that will transfer the control to 'target' */
#if PDI_SOLARIS_ELF_NATIVE_CLASS == 32
  /*     -> sethi %hi(target), %g1 */
  ((unsigned *) plt_address)[0] =              /* bits  => value       */
    ((0x00                      & 0x03) << 30) /* 31-30 => 00b         */
  | ((0x01                      & 0x1f) << 25) /* 29-25 => g1 (r1)     */
  | ((0x04                      & 0x07) << 22) /* 24-22 => 100b        */
  | ((((unsigned) target >> 10) & 0x3fffff));  /* 21-00 => %hi(target) */
  /*     -> jmpl %g1+%lo(target), %g0 */
  ((unsigned *) plt_address)[1] =              /* bits  => value       */
      ((0x02                & 0x03 ) << 30)    /* 31-30 => 10b         */
    | ((0x00                & 0x1f ) << 25)    /* 29-25 => g0 (r0)     */
    | ((0x38                & 0x3f ) << 19)    /* 24-19 => 111000b     */
    | ((0x01                & 0x1f ) << 14)    /* 18-14 => g1 (r1)     */
    | ((0x01                & 0x01 ) << 13)    /*  13   => 1b          */
    | ((((unsigned) target) & 0x3ff) <<  0);   /* 12-00 => %lo(target) */
  /*     -> nop */
  ((unsigned *) plt_address)[2] = 0x01000000;

#elif PDI_SOLARIS_ELF_NATIVE_CLASS == 64
  if((((ElfW(Addr)) target) & 0xFFFFFFFF00000000L) != 0)
  {
    /* Jump very very far (more than 4Gb!!!!) */
    if(((ElfW(Addr)) target & 0xFFFFFFFF00000000L) == 0xFFFFFFFF00000000L)
    {
      /* VERY VERY VERY FAR */
      /*     -> sethi %hi(target), %g5 */
      ((unsigned *) plt_address)[0] =                   /* bits  => value    */
        ((0x00                           & 0x03) << 30) /* 31-30 => 00b      */
      | ((0x05                           & 0x1f) << 25) /* 29-25 => g5 (r5)  */
      | ((0x04                           & 0x07) << 22) /* 24-22 => 100b     */
      | (((~((ElfW(Addr)) target) >> 10) & 0x3fffff));  /* 21-00 => %hi(trg) */
      /*     -> xnor  %g5, %lo(target), %g1 */
      ((unsigned *) plt_address)[1] =                    /* bits  => value   */
        ((0x02                            & 0x03) << 30) /* 31-30 => 10b     */
      | ((0x01                            & 0x1f) << 25) /* 29-25 => g1 (r1) */
      | ((0x07                            & 0x3f) << 19) /* 24-19 => 000111b */
      | ((0x05                            & 0x1f) << 14) /* 18-14 => g5 (r5) */
      | ((0x01                            & 0x01) << 13) /*   13  => immed   */
      | ((~((ElfW(Addr)) target)          & 0x03ff));    /* 12-00 => 0x0000  */
      /*     -> jmpl  %g1, %g0 */
      ((unsigned *) plt_address)[2] =              /* bits  => value       */
          ((0x02                & 0x03 ) << 30)    /* 31-30 => 10b         */
        | ((0x00                & 0x1f ) << 25)    /* 29-25 => g0 (r0)     */
        | ((0x38                & 0x3f ) << 19)    /* 24-19 => 111000b     */
        | ((0x01                & 0x1f ) << 14)    /* 18-14 => g1 (r1)     */
        | ((0x01                & 0x01 ) << 13)    /*  13   => 1b          */
        | ((0x00                & 0x3ff) <<  0);   /* 12-00 => 0x00 */
      /*     -> nop */
      ((unsigned *) plt_address)[3] = 0x01000000;
    } else {
      /* Really far branch */
      /* Functions: */
      /*   %hh (address >> 42)            Extract bits 42-63 of a 64-bit word */
      /*   %hm (address >> 32) & 0x3ff    Extract bits 32-41 of a 64-bit word */
      /*   %lm (address >> 10) & 0x3fffff Extract bits 10-31 of a 64-bit word */
      /*     -> sethi %hh(target), %g1 */
      ((unsigned *) plt_address)[0] =                   /* bits  => value    */
        ((0x00                           & 0x03) << 30) /* 31-30 => 00b      */
      | ((0x01                           & 0x1f) << 25) /* 29-25 => g1 (r1)  */
      | ((0x04                           & 0x07) << 22) /* 24-22 => 100b     */
      | ((((ElfW(Addr)) target) >> 42)   & 0x3fffff);   /* 21-00 => %hh(trg) */
      /*     -> sethi %lm(target), %g5 */
      ((unsigned *) plt_address)[1] =                   /* bits  => value    */
        ((0x00                           & 0x03) << 30) /* 31-30 => 00b      */
      | ((0x05                           & 0x1f) << 25) /* 29-25 => g5 (r5)  */
      | ((0x04                           & 0x07) << 22) /* 24-22 => 100b     */
      | ((((ElfW(Addr)) target) >> 10)   & 0x3fffff);   /* 21-00 => %hi(trg) */
      /*     -> or %g1, %hm(target), %g1 */
      ((unsigned *) plt_address)[2] =                   /* bits  => value    */
        ((0x02                           & 0x03) << 30) /* 31-30 => 10b      */
      | ((0x01                           & 0x1f) << 25) /* 29-25 => g1 (r1)  */
      | ((0x02                           & 0x3f) << 19) /* 24-19 => 000010b  */
      | ((0x01                           & 0x1f) << 14) /* 18-14 => g0 (r0)  */
      | ((0x01                           & 0x01) << 13) /*   13  => immed    */
      | ((((ElfW(Addr)) target) >> 32) & 0x3ff);        /* 12-00 => %hi(trg) */
      /*     -> sllx %g1, 32, %g1 */
      ((unsigned *) plt_address)[3] =                   /* bits  => value    */
        ((0x02                           & 0x03) << 30) /* 31-30 => 10b      */
      | ((0x01                           & 0x1f) << 25) /* 29-25 => g1 (r1)  */
      | ((0x25                           & 0x3f) << 19) /* 24-19 => 100101b  */
      | ((0x01                           & 0x1f) << 14) /* 18-14 => g1 (r1)  */
      | ((0x01                           & 0x01) << 13) /*   13  => immed    */
      | ((0x01                           & 0x01) << 12) /*   12  => x=1      */
      | ((32                             & 0x3f));      /* 05-00 => 32       */
      /*     -> or %g1, %g5, %g5 */
      ((unsigned *) plt_address)[4] =                   /* bits  => value    */
        ((0x02                           & 0x03) << 30) /* 31-30 => 10b      */
      | ((0x05                           & 0x1f) << 25) /* 29-25 => g5 (r5)  */
      | ((0x02                           & 0x3f) << 19) /* 24-19 => 000010b  */
      | ((0x01                           & 0x1f) << 14) /* 18-14 => g1 (r1)  */
      | ((0x00                           & 0x01) << 13) /*   13  => register */
      | ((0x05                           & 0x1f));      /*  4-0  => g5 (r5)  */
      /*     -> jmpl %g5+%lo(target), %g0 */
      ((unsigned *) plt_address)[5] =                /* bits  => value       */
          ((0x02                  & 0x03 ) << 30)    /* 31-30 => 10b         */
        | ((0x00                  & 0x1f ) << 25)    /* 29-25 => g0 (r0)     */
        | ((0x38                  & 0x3f ) << 19)    /* 24-19 => 111000b     */
        | ((0x05                  & 0x1f ) << 14)    /* 18-14 => g5 (r5)     */
        | ((0x01                  & 0x01 ) << 13)    /*  13   => 1b          */
        | ((((ElfW(Addr)) target) & 0x3ff));         /* 12-00 => %lo(target) */
      /*     -> nop */
      ((unsigned *) plt_address)[6] = 0x01000000;
    }
  } else {
    /* Less than 4Gb branch */
    /*     -> sethi %hi(target), %g1 */
    ((unsigned *) plt_address)[0] =                /* bits  => value       */
      ((0x00                        & 0x03) << 30) /* 31-30 => 00b         */
    | ((0x01                        & 0x1f) << 25) /* 29-25 => g1 (r1)     */
    | ((0x04                        & 0x07) << 22) /* 24-22 => 100b        */
    | ((((ElfW(Addr)) target >> 10) & 0x3fffff));  /* 21-00 => %hi(target) */
    /*     -> jmpl %g1+%lo(target), %g0 */
    ((unsigned *) plt_address)[1] =                /* bits  => value       */
        ((0x02                  & 0x03 ) << 30)    /* 31-30 => 10b         */
      | ((0x00                  & 0x1f ) << 25)    /* 29-25 => g0 (r0)     */
      | ((0x38                  & 0x3f ) << 19)    /* 24-19 => 111000b     */
      | ((0x01                  & 0x1f ) << 14)    /* 18-14 => g1 (r1)     */
      | ((0x01                  & 0x01 ) << 13)    /*  13   => 1b          */
      | ((((ElfW(Addr)) target) & 0x3ff) <<  0);   /* 12-00 => %lo(target) */
    /*     -> nop */
    ((unsigned *) plt_address)[2] = 0x01000000;
  }
#else
#error "With how many bits are you working!?!?!?"
#endif

  return plt_address;
}

/*****************************************************************************
 * void _pdi_solaris_restorePlt(ElfW(Addr) plt_address, void *orig_code)
 *
 * Description:
 *   Restore a PLT slot with code stored in 'orig_code'.
 *
 * Parameters:
 *   plt_address - address where copy the original PLT code
 *   orig_code   - pointer to the original code
 *
 * Returns:
 *   -nothing-
 *
 *****************************************************************************/

void _pdi_solaris_restorePlt(ElfW(Addr) plt_address, void *orig_code)
{
  memcpy(orig_code, (void *) plt_address, PDI_SOLARIS_RELINK_CODE_UNDO_SZ);
}

