/*****************************************************************************
 * $Id: safefunc.c,v 1.1 2005/08/23 11:02:37 killabyte Exp $
 *
 * This object declares some function pointers to the *real* address of some
 * functions. The objective of this pointers is to avoid runtime linker
 * mechanisms.
 *
 * ---------------------------------------------------------------------------
 * pDI-Tools - portable Dynamic Instrumentation Tools
 *   (C) 2004, 2005 Gerardo Garca Pea
 *   Programmed by Gerardo Garca Pea - Inspired on CEPBA DItools
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 *   USA
 *
 *****************************************************************************/

#include<config.h>
#include<safefunc.h>

int (*_pdi_safe_fflush)(FILE *stream);
int (*_pdi_safe_fprintf)(FILE *stream, const char *format, ...);
int (*_pdi_safe_fputc)(int c, FILE *stream);
int (*_pdi_safe_fputs)(const char *s, FILE *stream);
int (*_pdi_safe_vfprintf)(FILE *stream, const char *format, va_list ap);

int _pdi_initSafeFuncs(void)
{
  /* De momento, y como bien dice el dicho: a falta de pan buenas son   */
  /* tortas, nos limitamos a asignar unos dbiles punteritos a nuestras */
  /* funciones _pdi_safe_* que se supone que la parte dependiente de la */
  /* arquitectura arreglar.                                            */
  _pdi_safe_fflush   = fflush;
  _pdi_safe_fprintf  = fprintf;
  _pdi_safe_fputc    = fputc;
  _pdi_safe_fputs    = fputs;
  _pdi_safe_vfprintf = vfprintf;

  return 0;
}

